// Momiji.Test.MM.WaveOut.cpp : C vWFNg t@CłB

#include "stdafx.h"
#using <..\..\Release\Momiji.Core.dll>

using namespace System;

void test1()
{
	System::UInt32 nums = Momiji::Core::Wave::Out::Device::GetNumDevices();
	Console::WriteLine("[{0}]", nums);

	Console::WriteLine("====================================================");
	for (System::UInt32 idx = 0; idx <= nums; idx++) {

		try
		{
			auto cap = Momiji::Core::Wave::Out::Device::GetCapabilities(idx);

			Console::Write("[{0}]", idx);
			Console::Write("[{0}]", cap->manufacturerID);
			Console::Write("[{0}]", cap->productID);
			Console::Write("[{0}]", cap->driverVersion);
			Console::Write("[{0}]", cap->productName);
			Console::Write("[{0:f}]", cap->formats);
			Console::Write("[{0}]", cap->channels);
			Console::Write("[{0}]", cap->reserved1);
			Console::Write("[{0}]", cap->support);
			Console::WriteLine();

			Console::WriteLine("[{0}]", cap->manufacturerGuid);
			Console::WriteLine("[{0}]", cap->productGuid);
			Console::WriteLine("[{0}]", cap->nameGuid);
		}
		catch(Exception^ e)
		{
			Console::WriteLine(e->ToString());
		}
	}
}

System::Single Modulus(System::Single dividend, System::Single divisor)
{
	return
		static_cast<System::Single>(
			(Math::Abs(dividend) - (Math::Abs(divisor) * 
			(Math::Floor(Math::Abs(dividend) / Math::Abs(divisor))))) * 
			Math::Sign(dividend)
		);
}

void test2_1(
	System::UInt32 s
)
{
	try
	{
		auto out =
			gcnew Momiji::Core::Wave::Out::Device(
				0,
				1,
				s,
				System::Runtime::InteropServices::Marshal::SizeOf(System::Single::typeid) * 8,
				(
					Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_LEFT
				|	Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_RIGHT
				),
				Momiji::Interop::Ks::StaticKs::SUBTYPE_PCM,
				s
			);

		try
		{
			auto cap = out->GetCapabilities();

			Console::Write("[{0}]", cap->manufacturerID);
			Console::Write("[{0}]", cap->productID);
			Console::Write("[{0}]", cap->driverVersion);
			Console::Write("[{0}]", cap->productName);
			Console::Write("[{0}]", cap->formats);
			Console::Write("[{0}]", cap->channels);
			Console::Write("[{0}]", cap->reserved1);
			Console::Write("[{0}]", cap->support);
			Console::WriteLine();

			delete cap;

			System::GC::Collect();

			auto count = s*8;
			auto data = gcnew array<System::Single>(count);

			for(System::UInt32 idx = 0; idx < count; idx++)
			{
				System::Single d = .0;

				System::Single ll = static_cast<System::Single>(s / (440.0 + ((440.0 / (count)) * idx * 12)));

				if(Modulus(static_cast<System::Single>(idx), ll) < (ll / 2))
				{
					d += System::Single::MaxValue / 4;
				}
				else
				{
					d -= System::Single::MaxValue / 4;
				}

				d = (d > System::Single::MaxValue) ? System::Single::MaxValue: d;
				d = (d < System::Single::MinValue) ? System::Single::MinValue: d;

				data[idx] = d;
			}

			auto handle = System::Runtime::InteropServices::GCHandle::Alloc(data, System::Runtime::InteropServices::GCHandleType::Pinned);

			out->Send(handle.AddrOfPinnedObject(), count);
			//System::Console::ReadLine();
			out->Send(handle.AddrOfPinnedObject(), count);
			System::Console::ReadLine();

			if (handle.IsAllocated)
			{
				handle.Free();
				delete data;
			}
		}
		finally
		{
			delete out;
		}
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}

void test2()
{
	test2_1(4000);
	test2_1(8000);
	test2_1(16000);
	test2_1(28800);
	test2_1(41100);
	test2_1(48000);
	test2_1(96000);
}

void test3()
{
	try
	{
		delete 
			gcnew Momiji::Core::Wave::Out::Device(
				0,
				1,
				48000,
				16,
				(
					Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_LEFT
				|	Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_RIGHT
				),
				Momiji::Interop::Ks::StaticKs::SUBTYPE_PCM,
				48000
			);
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}

void test4()
{
	try
	{
		Console::WriteLine("======== Momiji::Core::WaveOut^ out1 = gcnew Momiji::Core::WaveOut(0)");
		auto out1 = 
			gcnew Momiji::Core::Wave::Out::Device(
				0,
				1,
				48000,
				16,
				(
					Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_LEFT
				|	Momiji::Interop::Winmm::WaveFormatExtensiblePart::SPEAKER::FRONT_RIGHT
				),
				Momiji::Interop::Ks::StaticKs::SUBTYPE_PCM,
				48000
			);

		{
			Console::WriteLine("======== Momiji::Core::WaveOut^ out2 = out1;");
			auto out2 = out1;
		}
		Console::WriteLine("======== System::GC::Collect();");
		System::GC::Collect();
		System::GC::WaitForPendingFinalizers();
		System::GC::Collect();

		Console::WriteLine("======== Momiji::Core::WaveOut^ out3 = out1;");
		auto out3 = out1;

		Console::WriteLine("======== delete out3;");
		delete out3;
		System::GC::Collect();
		System::GC::WaitForPendingFinalizers();
		System::GC::Collect();

		Console::WriteLine("======== delete out1;");
		delete out1;
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}


int main(array<System::String ^> ^args)
{
   	Console::WriteLine("====================================================test1");
	test1();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================test2");
	test2();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================test3");
	test3();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();
	
	Console::WriteLine("====================================================test4");
	test4();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================");
	System::Console::ReadLine();
    return 0;
}
