// Momiji.Test.MM.MidiOut.cpp : C vWFNg t@CłB

#include "stdafx.h"
#using <Momiji.Core.dll>

using namespace System;

void test1()
{
	System::UInt32 nums = Momiji::Core::Midi::Out::Device::GetNumDevices();
	Console::WriteLine("[{0}]", nums);

	Console::WriteLine("====================================================");
	for (System::UInt32 idx = 0; idx <= nums; idx++) {

		try
		{
			Momiji::Interop::Winmm::MidiOutCapabilities^ cap = 
				Momiji::Core::Midi::Out::Device::GetCapabilities(idx);

			Console::Write("[{0}]", idx);
			Console::Write("[{0}]", cap->manufacturerID);
			Console::Write("[{0}]", cap->productID);
			Console::Write("[{0}]", cap->driverVersion);
			Console::Write("[{0}]", cap->productName);
			Console::Write("[{0}]", cap->technology);
			Console::Write("[{0}]", cap->voices);
			Console::Write("[{0}]", cap->notes);
			Console::Write("[{0}]", cap->channelMask);
			Console::Write("[{0}]", cap->support);
			Console::WriteLine();

			Console::WriteLine("[{0}]", cap->manufacturerGuid);
			Console::WriteLine("[{0}]", cap->productGuid);
			Console::WriteLine("[{0}]", cap->nameGuid);
		}
		catch(Exception^ e)
		{
			Console::WriteLine(e->ToString());
		}
	}
}

void test2()
{
	try
	{
		Momiji::Core::Midi::Out::Device^ out = gcnew Momiji::Core::Midi::Out::Device(0);
		try
		{
			Momiji::Interop::Winmm::MidiOutCapabilities^ cap = out->GetCapabilities();

			Console::Write("[{0}]", cap->manufacturerID);
			Console::Write("[{0}]", cap->productID);
			Console::Write("[{0}]", cap->driverVersion);
			Console::Write("[{0}]", cap->productName);
			Console::Write("[{0}]", cap->technology);
			Console::Write("[{0}]", cap->voices);
			Console::Write("[{0}]", cap->notes);
			Console::Write("[{0}]", cap->channelMask);
			Console::Write("[{0}]", cap->support);
			Console::WriteLine();

			delete cap;

		//	out->open();

			System::GC::Collect();

			out->SendShort(0x00505090l);
			out->SendShort(0x00505590l);
			out->SendShort(0x00505890l);

			out->SendShort(0x00005090l);
			out->SendShort(0x00005590l);
			out->SendShort(0x00005890l);

			array<System::Byte>^ data = {0xF0,0x41,0x10,0x42,0x12,0x40,0x00,0x7F,0x00,0x41,0xF7};
			out->SendLong(data, data->Length);
			out->SendLong(data, data->Length);
			out->SendLong(data, data->Length);

		//	out->close();
		}
		finally
		{
			delete out;
		}
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}

void test3()
{
	try
	{
		delete gcnew Momiji::Core::Midi::Out::Device(0);
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}

void test4()
{
	try
	{
		Console::WriteLine("======== Momiji::Core::MidiOut^ out1 = gcnew Momiji::Core::MidiOut(0)");
		Momiji::Core::Midi::Out::Device^ out1 = gcnew Momiji::Core::Midi::Out::Device(0);

		{
			Console::WriteLine("======== Momiji::Core::MidiOut^ out2 = out1;");
			Momiji::Core::Midi::Out::Device^ out2 = out1;
		}
		Console::WriteLine("======== System::GC::Collect();");
		System::GC::Collect();
		System::GC::WaitForPendingFinalizers();
		System::GC::Collect();

		Console::WriteLine("======== Momiji::Core::MidiOut^ out3 = out1;");
		Momiji::Core::Midi::Out::Device^ out3 = out1;

		Console::WriteLine("======== delete out3;");
		delete out3;
		System::GC::Collect();
		System::GC::WaitForPendingFinalizers();
		System::GC::Collect();

		Console::WriteLine("======== delete out1;");
		delete out1;
	}
	catch(Exception^ e)
	{
		Console::WriteLine(e->ToString());
	}
}


int main(array<System::String ^> ^args)
{
   	Console::WriteLine("====================================================test1");
	test1();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================test2");
	test2();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================test3");
	test3();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();
	
	Console::WriteLine("====================================================test4");
	test4();
	System::GC::Collect();
	System::GC::WaitForPendingFinalizers();
	System::GC::Collect();

	Console::WriteLine("====================================================");
	System::Console::ReadLine();
    return 0;
}
