﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Momiji.Core.Test
{
	class Sequence: IDisposable
	{
		private Momiji.Sequencer.Wave.WaveStream s;
		private Momiji.Core.Wave.Out.Device o;
		private System.UInt32 _samplesPerBuffer;

		private Momiji.Core.Buffer.BufferPool<System.Byte[]> _bufferPool;

		private System.Boolean _end;

		private void OnDone(System.Object sender, Momiji.Core.Wave.Out.Device.UnpreparedEventArgs args)
		{
			//TODO. バッファの開放
			var buffer = this._bufferPool.GetBusy(args.bufferPtr);
			this._bufferPool.Release(buffer);

			if (!this._end) {
				this.Cycle();
			}
		}

		private void Cycle()
		{
			var buffer = this._bufferPool.Get();

			var size = s.Read(buffer, this._samplesPerBuffer);
			o.Send(buffer.GetBufferIntPtr(), size);
		}

		private System.Byte[] AllocateBuffer()
		{
			return new System.Byte[100000];
		}

		public Sequence(System.String fileName, System.UInt32 samplesPerBuffer)
		{
			this._samplesPerBuffer = samplesPerBuffer;
			this._end = false;

			this.s = new Momiji.Sequencer.Wave.WaveStream(fileName);
			var wfx = s.format;

			this._bufferPool =
				new Momiji.Core.Buffer.BufferPool<System.Byte[]>(
					((wfx.samplesPerSecond / (samplesPerBuffer * wfx.blockAlign)) + 2), //１秒分＋２回
					new Momiji.Core.Buffer.BufferPool<System.Byte[]>.Allocator(this.AllocateBuffer) 
				);

			var count = (wfx.samplesPerSecond / this._samplesPerBuffer) + 2;

			Console.WriteLine("samplesPerBuffer {0} count {1}", this._samplesPerBuffer, count);

			this.o = new Momiji.Core.Wave.Out.Device(
					0,
					wfx.channels,
					wfx.samplesPerSecond,
					wfx.bitsPerSample,
					(
						Momiji.Interop.Winmm.WaveFormatExtensiblePart.SPEAKER.FRONT_LEFT
					|	Momiji.Interop.Winmm.WaveFormatExtensiblePart.SPEAKER.FRONT_RIGHT
					),
					Momiji.Interop.Ks.StaticKs.SUBTYPE_PCM,
					this._samplesPerBuffer
				);

			this.o.OnDone += new System.EventHandler<Momiji.Core.Wave.Out.Device.UnpreparedEventArgs>(this.OnDone);

			//このやり方は、周ってる間にOnDoneが発生して順番が崩れるかも？
			for (var i = 0; i < count; i++)
			{
				this.Cycle();
			}
		}

		public void Dispose()
		{
			this._end = true;

			this.o.Reset();

			//バッファの開放待ち
			while(this._bufferPool.IsBusy())
			{
				//#ifdef _DEBUG
					System.Console.WriteLine("wait for unprepare buffers ...");
				//#endif
				System.Threading.Thread.Sleep(5);
			}

			if (this.o != null)
			{
				this.o.OnDone -= new System.EventHandler<Momiji.Core.Wave.Out.Device.UnpreparedEventArgs>(this.OnDone);
				this.o.Dispose();
				this.o = null;
			}

			if (this.s != null)
			{
				this.s.Dispose();
				this.s = null;
			}
				
			if (this._bufferPool != null)
			{
				this._bufferPool.Dispose();
				this._bufferPool = null;
			}
		}
	}
}
