﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;


namespace Momiji.Core.Test
{
    class Data
    {
        private System.Collections.Generic.List<Momiji.Interop.Winmm.WaveOutCapabilities> _waveOutCapabilities;

        public System.Collections.Generic.List<Momiji.Interop.Winmm.WaveOutCapabilities> waveOutCapabilitiesList { get {return this._waveOutCapabilities; } }
        public Momiji.Interop.Winmm.WaveOutCapabilities waveOutCapabilitiesSelect { get; set; }

        public Data()
        {
			System.Console.WriteLine("Data construct");

            this._waveOutCapabilities =
                new System.Collections.Generic.List<Momiji.Interop.Winmm.WaveOutCapabilities>();

            System.UInt32 nums = Momiji.Core.Wave.Out.Device.GetNumDevices();

            for (System.UInt32 idx = 0; idx < nums; idx++)
            {
                var cap = Momiji.Core.Wave.Out.Device.GetCapabilities(idx);
                this._waveOutCapabilities.Add(cap);
            }

            this.waveOutCapabilitiesSelect = this._waveOutCapabilities[0];
        }

    }

	[System.Windows.Data.ValueConversion(typeof(System.Object), typeof(System.Collections.Generic.List<System.ComponentModel.ItemPropertyInfo>))]
	class FieldListConverter : System.Windows.Data.IValueConverter
	{
		public System.Object Convert(System.Object value, System.Type targetType, System.Object parameter, System.Globalization.CultureInfo culture)
		{
			System.Console.WriteLine("FieldListConverter Convert");
			var result = new System.Collections.Generic.List<System.ComponentModel.ItemPropertyInfo>();
			var fields = value.GetType().GetFields(System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.Public);
			foreach (var f in fields)
			{
				var item = new System.ComponentModel.ItemPropertyInfo(f.Name, f.FieldType, f.GetValue(value));
				result.Add(item);
			}

			return result;
		}

		public System.Object ConvertBack(System.Object value, System.Type targetType, System.Object parameter, System.Globalization.CultureInfo culture)
		{
			return System.Windows.DependencyProperty.UnsetValue;
		}
	}

	[System.Windows.Data.ValueConversion(typeof(System.Object), typeof(System.Object))]
	class FieldConverter : System.Windows.Data.IValueConverter
	{
		public System.Object Convert(System.Object value, System.Type targetType, System.Object parameter, System.Globalization.CultureInfo culture)
		{
			System.Console.WriteLine("FieldConverter Convert");
			var f = value.GetType().GetField(parameter as System.String, System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.Public);
			return f.GetValue(value);
		}

		public System.Object ConvertBack(System.Object value, System.Type targetType, System.Object parameter, System.Globalization.CultureInfo culture)
		{
			return System.Windows.DependencyProperty.UnsetValue;
		}
	}
}
