﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Interop.Setupapi.h
	windows multi media dll importer.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
#include "Momiji.Interop.Guiddef.h"
#include "Momiji.Interop.Kernel32.h"

using namespace System::Runtime;

namespace Momiji{
namespace Interop {
namespace Setupapi {

#define SETUP_API_DLLIMPORT		WIN32_DLL_IMPORT("setupapi")
#define ADV_API_DLLIMPORT		WIN32_DLL_IMPORT("advapi32")

	[System::FlagsAttribute]
	public enum class DIGCF: System::UInt32
	{
		DEFAULT			= 0x00000001,	// only valid with DIGCF_DEVICEINTERFACE
		PRESENT			= 0x00000002,
		ALLCLASSES		= 0x00000004,
		PROFILE			= 0x00000008,
		DEVICEINTERFACE	= 0x00000010,
	};

	public enum class SPDRP: System::UInt32
	{
		DEVICEDESC                  = 0x00000000,	  // DeviceDesc = R/W,	
		HARDWAREID                  = 0x00000001,	  // HardwareID = R/W,	
		COMPATIBLEIDS               = 0x00000002,	  // CompatibleIDs = R/W,	
		UNUSED0                     = 0x00000003,	  // unused
		SERVICE                     = 0x00000004,	  // Service = R/W,	
		UNUSED1                     = 0x00000005,	  // unused
		UNUSED2                     = 0x00000006,	  // unused
		CLASS                       = 0x00000007,	  // Class = R--tied to ClassGUID,	
		CLASSGUID                   = 0x00000008,	  // ClassGUID = R/W,	
		DRIVER                      = 0x00000009,	  // Driver = R/W,	
		CONFIGFLAGS                 = 0x0000000A,	  // ConfigFlags = R/W,	
		MFG                         = 0x0000000B,	  // Mfg = R/W,	
		FRIENDLYNAME                = 0x0000000C,	  // FriendlyName = R/W,	
		LOCATION_INFORMATION        = 0x0000000D,	  // LocationInformation = R/W,	
		PHYSICAL_DEVICE_OBJECT_NAME = 0x0000000E,	  // PhysicalDeviceObjectName = R,	
		CAPABILITIES                = 0x0000000F,	  // Capabilities = R,	
		UI_NUMBER                   = 0x00000010,	  // UiNumber = R,	
		UPPERFILTERS                = 0x00000011,	  // UpperFilters = R/W,	
		LOWERFILTERS                = 0x00000012,	  // LowerFilters = R/W,	
		BUSTYPEGUID                 = 0x00000013,	  // BusTypeGUID = R,	
		LEGACYBUSTYPE               = 0x00000014,	  // LegacyBusType = R,	
		BUSNUMBER                   = 0x00000015,	  // BusNumber = R,	
		ENUMERATOR_NAME             = 0x00000016,	  // Enumerator Name = R,	
		SECURITY                    = 0x00000017,	  // Security = R/W, binary form,	
		SECURITY_SDS                = 0x00000018,	  // Security = W, SDS form,	
		DEVTYPE                     = 0x00000019,	  // Device Type = R/W,	
		EXCLUSIVE                   = 0x0000001A,	  // Device is exclusive-access = R/W,	
		CHARACTERISTICS             = 0x0000001B,	  // Device Characteristics = R/W,	
		ADDRESS                     = 0x0000001C,	  // Device Address = R,	
		UI_NUMBER_DESC_FORMAT       = 0X0000001D,	  // UiNumberDescFormat = R/W,	
		DEVICE_POWER_DATA           = 0x0000001E,	  // Device Power Data = R,	
		REMOVAL_POLICY              = 0x0000001F,	  // Removal Policy = R,	
		REMOVAL_POLICY_HW_DEFAULT   = 0x00000020,	  // Hardware Removal Policy = R,	
		REMOVAL_POLICY_OVERRIDE     = 0x00000021,	  // Removal Policy Override = RW,	
		INSTALL_STATE               = 0x00000022,	  // Device Install State = R,	
		LOCATION_PATHS              = 0x00000023,	  // Device Location Paths = R,	
		BASE_CONTAINERID            = 0x00000024,	  // Base ContainerID = R,	
	};

	//
	// Flags for SP_DEVICE_INTERFACE_DATA.Flags field.
	//
	[System::FlagsAttribute]
	public enum class SPINT: System::UInt32
	{
		ACTIVE	= 0x00000001,
		DEFAULT	= 0x00000002,
		REMOVED	= 0x00000004,
	};


	//
	// Device information structure (references a device instance
	// that is a member of a device information set)
	//
	WIN32_DLL_STRUCTLAYOUT public value struct SpDevinfoData {
		System::UInt32	cbSize;
		Guiddef::Guid	ClassGuid;
		System::UInt32	DevInst;    // DEVINST handle
		System::IntPtr	Reserved;

		virtual System::String^ ToString() override
		{
			return 
				"cbSize["+cbSize+"] classGuid["+ClassGuid+"] devInst["+DevInst+"]";
		}
	};

	//
	// Device interface information structure (references a device
	// interface that is associated with the device information
	// element that owns it).
	//
	WIN32_DLL_STRUCTLAYOUT public value struct SpDeviceInterfaceData {
		System::UInt32	cbSize;
		Guiddef::Guid	InterfaceClassGuid;
		SPINT			Flags;
		System::IntPtr	Reserved;

		virtual System::String^ ToString() override
		{
			return 
				"cbSize["+cbSize+"] interfaceClassGuid["+InterfaceClassGuid+"] flags["+Flags.ToString("F")+"]";
		}
	};

	//TODO: 64bitの場合は8バイトでパッキングする必要がある
	WIN32_DLL_STRUCTLAYOUT public value struct SpDeviceInterfaceDetailData {
		System::UInt32	cbSize;
		[InteropServices::MarshalAs(InteropServices::UnmanagedType::ByValTStr, SizeConst=1024)]
			System::String^		DevicePath;

		virtual System::String^ ToString() override
		{
			return 
				"cbSize["+cbSize+"] devicePath["+DevicePath+"]";
		}
	};

	public value class Function
	{
	public:
		[System::Security::Permissions::SecurityPermissionAttribute(System::Security::Permissions::SecurityAction::InheritanceDemand, UnmanagedCode = true)]
		ref class DeviceInfoSet
			: public Microsoft::Win32::SafeHandles::SafeHandleZeroOrMinusOneIsInvalid
		{
		public:
			DeviceInfoSet(): Microsoft::Win32::SafeHandles::SafeHandleZeroOrMinusOneIsInvalid(true) {};

		protected:
			virtual System::Boolean ReleaseHandle() override
			{
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}]",__FUNCTION__);
				#endif

				if (this->IsInvalid)
				{
					#ifdef _DEBUG
						System::Console::WriteLine("[{0}] invalid",__FUNCTION__);
					#endif

					return false;
				}

				System::Boolean result = SetupDiDestroyDeviceInfoList(this->handle);

				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] result {1}",__FUNCTION__, result);
				#endif
				return result;
			};
		};

		SETUP_API_DLLIMPORT static DeviceInfoSet^ SetupDiGetClassDevs(
			[InteropServices::In]	Guiddef::Guid%				classGuid, 
			[InteropServices::In]	System::String^				enumerator, 
			[InteropServices::In]	InteropServices::HandleRef	hwndParent, 
			[InteropServices::In]	DIGCF						flags
		);
	private:
		SETUP_API_DLLIMPORT static System::Boolean SetupDiDestroyDeviceInfoList(
			[InteropServices::In]	System::IntPtr				deviceInfoSet
		);
	public:
		SETUP_API_DLLIMPORT static System::Boolean SetupDiEnumDeviceInterfaces(
			[InteropServices::In]	DeviceInfoSet^				deviceInfoSet,
			[InteropServices::In]	SpDevinfoData^				deviceInfoData,
			[InteropServices::In]	Guiddef::Guid%				interfaceClassGuid, 
			[InteropServices::In]	System::UInt32				memberIndex,
			[InteropServices::In, InteropServices::Out]	SpDeviceInterfaceData%		deviceInterfaceData
		);

		SETUP_API_DLLIMPORT static System::Boolean SetupDiGetDeviceInterfaceDetail(
			[InteropServices::In]	DeviceInfoSet^				deviceInfoSet,
			[InteropServices::In]	SpDeviceInterfaceData%		deviceInterfaceData,
			[InteropServices::In, InteropServices::Out]	SpDeviceInterfaceDetailData% deviceInterfaceDetailData,
			[InteropServices::In]	System::UInt32				deviceInterfaceDetailDataSize,
			[InteropServices::Out]	System::UInt32%				requiredSize, 
			[InteropServices::In, InteropServices::Out]	SpDevinfoData%	deviceInfoData
		);

		//サイズ取得用のオーバーロード
		SETUP_API_DLLIMPORT static System::Boolean SetupDiGetDeviceInterfaceDetail(
			[InteropServices::In]	DeviceInfoSet^				deviceInfoSet,
			[InteropServices::In]	SpDeviceInterfaceData%		deviceInterfaceData,
			[InteropServices::In]	System::IntPtr				deviceInterfaceDetailData,
			[InteropServices::In]	System::UInt32				deviceInterfaceDetailDataSize,
			[InteropServices::Out]	System::UInt32%				requiredSize, 
			[InteropServices::In]	System::IntPtr				deviceInfoData
		);

		SETUP_API_DLLIMPORT static System::Boolean SetupDiGetDeviceInterfaceAlias(
			[InteropServices::In]	DeviceInfoSet^				deviceInfoSet,
			[InteropServices::In]	SpDeviceInterfaceData%		deviceInterfaceData,
			[InteropServices::In]	Guiddef::Guid%				aliasInterfaceClassGuid, 
			[InteropServices::In, InteropServices::Out]	SpDeviceInterfaceData%		aliasDeviceInterfaceData
		);


		SETUP_API_DLLIMPORT static System::Boolean SetupDiGetDeviceRegistryProperty(
			[InteropServices::In]	DeviceInfoSet^					deviceInfoSet,
			[InteropServices::In]	SpDevinfoData%					deviceInfoData,
			[InteropServices::In]	SPDRP							propertyDrp,
			[InteropServices::Out]	System::UInt32%					propertyRegDataType,
			[InteropServices::Out]	System::Text::StringBuilder^	propertyBuffer,
			[InteropServices::In]	System::UInt32					propertyBufferSize,
			[InteropServices::Out]	System::UInt32%					requiredSize
		);

	public:
		[System::Security::Permissions::SecurityPermissionAttribute(System::Security::Permissions::SecurityAction::InheritanceDemand, UnmanagedCode = true)]
		ref class RegKey
			: public Microsoft::Win32::SafeHandles::SafeHandleZeroOrMinusOneIsInvalid
		{
		public:
			RegKey(): Microsoft::Win32::SafeHandles::SafeHandleZeroOrMinusOneIsInvalid(true) {};

		protected:
			virtual System::Boolean ReleaseHandle() override
			{
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}]",__FUNCTION__);
				#endif

				if (this->IsInvalid)
				{
					#ifdef _DEBUG
						System::Console::WriteLine("[{0}] invalid",__FUNCTION__);
					#endif

					return false;
				}

				System::UInt32 result = RegCloseKey(this->handle);

				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] result {1}",__FUNCTION__, result);
				#endif

				return (result == 0);
			};
		};

		SETUP_API_DLLIMPORT static RegKey^ SetupDiOpenDeviceInterfaceRegKey(
			[InteropServices::In]	DeviceInfoSet^				deviceInfoSet,
			[InteropServices::In]	SpDeviceInterfaceData%		deviceInterfaceData,
			[InteropServices::In]	System::UInt32				reserved,
			[InteropServices::In]	Interop::Kernel32::ACCESS_TYPES	samDesired
		);
	private:
		ADV_API_DLLIMPORT static System::UInt32 RegCloseKey(
			[InteropServices::In]	System::IntPtr				hKey
		);

	public:
		ADV_API_DLLIMPORT static System::UInt32 RegQueryValueEx(
			[InteropServices::In]	RegKey^			hKey,
			[InteropServices::In]	System::String^	lpValueName,
			[InteropServices::In]	System::IntPtr	lpReserved,
			[InteropServices::Out]	System::UInt32%	lpType,
			[InteropServices::In]	System::IntPtr	lpData,
			[InteropServices::In, InteropServices::Out]	System::UInt32%	lpcbData
		);
	};

}
}
}
