﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Interop.Kernel32.h
	windows kernel dll importer.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

//#include "Momiji.Interop.Ks.h"

using namespace System::Runtime;

namespace Momiji{
namespace Interop {
namespace Kernel32 {

#define KERNEL32_DLLIMPORT		WIN32_DLL_IMPORT("kernel32")
#define KERNEL32_DLLIMPORT_ANSI	WIN32_DLL_IMPORT_ANSI("kernel32")

	public enum class ACCESS_TYPES: System::UInt32
	{
	//  The following are masks for the predefined standard access types
		DELETE						= 0x00010000,
		READ_CONTROL				= 0x00020000,
		WRITE_DAC					= 0x00040000,
		WRITE_OWNER					= 0x00080000,
		SYNCHRONIZE					= 0x00100000,
		STANDARD_RIGHTS_REQUIRED	= 0x000F0000,
		STANDARD_RIGHTS_READ		= READ_CONTROL,
		STANDARD_RIGHTS_WRITE		= READ_CONTROL,
		STANDARD_RIGHTS_EXECUTE		= READ_CONTROL,
		STANDARD_RIGHTS_ALL			= 0x001F0000,
		SPECIFIC_RIGHTS_ALL			= 0x0000FFFF,
	// AccessSystemAcl access type
		ACCESS_SYSTEM_SECURITY		= 0x01000000,
	// MaximumAllowed access type
		MAXIMUM_ALLOWED				= 0x02000000,
	//  These are the generic rights.
		GENERIC_READ				= 0x80000000,
		GENERIC_WRITE				= 0x40000000,
		GENERIC_EXECUTE				= 0x20000000,
		GENERIC_ALL					= 0x10000000,


		KEY_QUERY_VALUE				= 0x0001,
		KEY_SET_VALUE				= 0x0002,
		KEY_CREATE_SUB_KEY			= 0x0004,
		KEY_ENUMERATE_SUB_KEYS		= 0x0008,
		KEY_NOTIFY					= 0x0010,
		KEY_CREATE_LINK				= 0x0020,
		KEY_WOW64_32KEY				= 0x0200,
		KEY_WOW64_64KEY				= 0x0100,
		KEY_WOW64_RES				= 0x0300,

		KEY_READ					= ((	STANDARD_RIGHTS_READ
										|	KEY_QUERY_VALUE
										|	KEY_ENUMERATE_SUB_KEYS
										|	KEY_NOTIFY)
										&	~SYNCHRONIZE),


		KEY_WRITE					= ((	STANDARD_RIGHTS_WRITE
										|	KEY_SET_VALUE
										|	KEY_CREATE_SUB_KEY)
										&	~SYNCHRONIZE),

		KEY_EXECUTE					= (KEY_READ & ~SYNCHRONIZE),

		KEY_ALL_ACCESS				= ((	STANDARD_RIGHTS_ALL
										|	KEY_QUERY_VALUE
										|	KEY_SET_VALUE
										|	KEY_CREATE_SUB_KEY
										|	KEY_ENUMERATE_SUB_KEYS
										|	KEY_NOTIFY
										|	KEY_CREATE_LINK)
										&	~SYNCHRONIZE),

	};

	public enum class SHARE_MODE: System::UInt32
	{
		FILE_SHARE_NONE				= 0x00000000,
		FILE_SHARE_READ				= 0x00000001,
		FILE_SHARE_WRITE			= 0x00000002,
		FILE_SHARE_DELETE			= 0x00000004,
	};

	public enum class CREATION_DISPOSITION: System::UInt32
	{
		CREATE_NEW			= 1,
		CREATE_ALWAYS		= 2,
		OPEN_EXISTING		= 3,
		OPEN_ALWAYS			= 4,
		TRUNCATE_EXISTING	= 5,
	};

	public enum class FLAG_AND_ATTRIBUTE: System::UInt32
	{
		FILE_ATTRIBUTE_READONLY				= 0x00000001,
		FILE_ATTRIBUTE_HIDDEN				= 0x00000002,
		FILE_ATTRIBUTE_SYSTEM				= 0x00000004,
		FILE_ATTRIBUTE_DIRECTORY			= 0x00000010,
		FILE_ATTRIBUTE_ARCHIVE				= 0x00000020,
		FILE_ATTRIBUTE_DEVICE				= 0x00000040,
		FILE_ATTRIBUTE_NORMAL				= 0x00000080,
		FILE_ATTRIBUTE_TEMPORARY			= 0x00000100,
		FILE_ATTRIBUTE_SPARSE_FILE			= 0x00000200,
		FILE_ATTRIBUTE_REPARSE_POINT		= 0x00000400,
		FILE_ATTRIBUTE_COMPRESSED			= 0x00000800,
		FILE_ATTRIBUTE_OFFLINE				= 0x00001000,
		FILE_ATTRIBUTE_NOT_CONTENT_INDEXED	= 0x00002000,
		FILE_ATTRIBUTE_ENCRYPTED			= 0x00004000,
		FILE_ATTRIBUTE_VIRTUAL				= 0x00010000,

		FILE_FLAG_FIRST_PIPE_INSTANCE		= 0x00080000,
		FILE_FLAG_OPEN_NO_RECALL			= 0x00100000,
		FILE_FLAG_OPEN_REPARSE_POINT		= 0x00200000,
		FILE_FLAG_POSIX_SEMANTICS			= 0x01000000,
		FILE_FLAG_BACKUP_SEMANTICS			= 0x02000000,
		FILE_FLAG_DELETE_ON_CLOSE			= 0x04000000,
		FILE_FLAG_SEQUENTIAL_SCAN			= 0x08000000,
		FILE_FLAG_RANDOM_ACCESS				= 0x10000000,
		FILE_FLAG_NO_BUFFERING				= 0x20000000,
		FILE_FLAG_OVERLAPPED				= 0x40000000,
		FILE_FLAG_WRITE_THROUGH				= 0x80000000,
	};

	public value class Function {

	public:
		[System::Security::Permissions::SecurityPermissionAttribute(System::Security::Permissions::SecurityAction::InheritanceDemand, UnmanagedCode = true)]
		ref class DynamicLinkLibrary
			: public Microsoft::Win32::SafeHandles::SafeHandleZeroOrMinusOneIsInvalid
		{
		public:
			DynamicLinkLibrary()
				: Microsoft::Win32::SafeHandles::SafeHandleZeroOrMinusOneIsInvalid(true)
			{
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}]",__FUNCTION__);
				#endif
			};

		protected:
			[ConstrainedExecution::ReliabilityContract(ConstrainedExecution::Consistency::WillNotCorruptState, ConstrainedExecution::Cer::MayFail)]
			virtual System::Boolean ReleaseHandle() override
			{
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}]",__FUNCTION__);
				#endif

				System::Boolean result = FreeLibrary(this->handle);

				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] FreeLibrary result {1}",__FUNCTION__, result);
				#endif
				return result;
			};
		};

		KERNEL32_DLLIMPORT static DynamicLinkLibrary^ LoadLibrary( 
			[InteropServices::In]	System::String^ lpFileName
		);
	private:
		KERNEL32_DLLIMPORT static System::Boolean FreeLibrary( 
			[InteropServices::In]	System::IntPtr hModule
		);

	public:
		KERNEL32_DLLIMPORT_ANSI static System::IntPtr GetProcAddress( 
			[InteropServices::In]	DynamicLinkLibrary^ hModule,
			[InteropServices::In]	System::String^ lpProcName
		);



		[System::Security::Permissions::SecurityPermissionAttribute(System::Security::Permissions::SecurityAction::InheritanceDemand, UnmanagedCode = true)]
		ref class File
			: public Microsoft::Win32::SafeHandles::SafeHandleZeroOrMinusOneIsInvalid
		{
		public:
			File()
				: Microsoft::Win32::SafeHandles::SafeHandleZeroOrMinusOneIsInvalid(true)
			{
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}]",__FUNCTION__);
				#endif
			};

		protected:
			[ConstrainedExecution::ReliabilityContract(ConstrainedExecution::Consistency::WillNotCorruptState, ConstrainedExecution::Cer::MayFail)]
			virtual System::Boolean ReleaseHandle() override
			{
				#ifdef _DEBUG
					System::Console::WriteLine("[{0}]",__FUNCTION__);
				#endif

				System::Boolean result = CloseHandle(this->handle);

				#ifdef _DEBUG
					System::Console::WriteLine("[{0}] CloseHandle result {1}",__FUNCTION__, result);
				#endif
				return result;
			};
		};

		KERNEL32_DLLIMPORT static File^ CreateFile( 
			[InteropServices::In]	System::String^			lpFileName,
			[InteropServices::In]	ACCESS_TYPES			dwDesiredAccess,
			[InteropServices::In]	SHARE_MODE				dwShareMode,
			[InteropServices::In]	System::IntPtr			lpSecurityAttributes,
			[InteropServices::In]	CREATION_DISPOSITION	dwCreationDisposition,
			[InteropServices::In]	FLAG_AND_ATTRIBUTE		dwFlagsAndAttributes,
			[InteropServices::In]	System::IntPtr			hTemplateFile
		);

	private:
		KERNEL32_DLLIMPORT static System::Boolean CloseHandle(
			[InteropServices::In]	System::IntPtr	hObject
		);

	};
	
}
}
}
