﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Wave.Out.h
	wave output component.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
#include "Momiji.Core.Interface.h"
#include "Momiji.Core.Winmm.h"
#include "Momiji.Core.Buffer.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Wave {
namespace Out {

	public ref class Device
	{
	private:
		initonly System::UInt32 _deviceID;

		initonly System::UInt16 _channels;
		initonly System::UInt32 _samplesPerSecond;
		initonly System::UInt16 _bitsPerSample;
		initonly Interop::Winmm::WaveFormatExtensiblePart::SPEAKER	_channelMask;
		initonly Interop::Guiddef::Guid	_formatSubType;
		initonly System::UInt32 _samplesPerBuffer;

		Interop::Winmm::Function::WaveOut^	_handle;
		Core::Winmm::DriverCallBack^		_callBack;
		Core::Buffer::BufferPool<Interop::Winmm::WaveHeader^>^ _headerPool;

	public:
		ref class UnpreparedEventArgs: System::EventArgs
		{
		public:
			System::IntPtr	bufferPtr;
		};

	public:
		Device(
			System::UInt32 deviceID,
			System::UInt16 channels,
			System::UInt32 samplesPerSecond,
			System::UInt16 bitsPerSample,
			Interop::Winmm::WaveFormatExtensiblePart::SPEAKER	channelMask,
			Interop::Guiddef::Guid formatSubType,
			System::UInt32 samplesPerBuffer
		);
		virtual ~Device();
	protected:
		!Device();

	private:
		System::IntPtr Prepare(System::IntPtr data, System::UInt32 useSize);
		System::IntPtr Unprepare(System::IntPtr headerPtr);

		Interop::Winmm::WaveHeader^ AllocateHeader();

	public:
		static System::UInt32 GetNumDevices();
		static Interop::Winmm::WaveOutCapabilities^ GetCapabilities(System::UInt32 uDeviceID);
		Interop::Winmm::WaveOutCapabilities^ GetCapabilities();

	private:
		void Open();
		void Close();

	public:
		//TODO: これのインタフェースは何かのBuffer情報の塊にしたい
		void Send(System::IntPtr data, System::UInt32 useSize);
		void Reset();

	public:
		event System::EventHandler<System::EventArgs^>^ OnOpen;
		event System::EventHandler<System::EventArgs^>^ OnClose;
		event System::EventHandler<UnpreparedEventArgs^>^ OnDone;

	private:
		void OnEventHandler(System::Object^ sender, Interop::Winmm::DriverCallBack::DriverEventArgs^ args);

		void DoOpen(System::IntPtr dwParam1, System::IntPtr dwParam2);
		void DoClose(System::IntPtr dwParam1, System::IntPtr dwParam2);
		void DoDone(System::IntPtr dwParam1, System::IntPtr dwParam2);
	};
	
	public ref class WaveOutException
		: public System::Exception
	{
	private:
		initonly Interop::Winmm::MMRESULT _mmResult;
		System::String^ Initialize();

	public:
		WaveOutException(Interop::Winmm::MMRESULT v): _mmResult(v), System::Exception(Initialize()){};
		WaveOutException(System::String^ v): System::Exception(v){};
		virtual ~WaveOutException(void){};

		property Interop::Winmm::MMRESULT mmResult
		{
			Interop::Winmm::MMRESULT get(void) {return this->_mmResult;};
		}
	};

}
}
}
}
