﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Vst.Host.h
	vst host component.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

#include "Momiji.Interop.Kernel32.h"
#include "Momiji.Interop.Vst.h"
#include "Momiji.Core.Vst.Buffer.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Vst {
namespace Host {

	public ref class Master
	{
	private:
		ref class AudioMasterCallBack
		{
		private:
			InteropServices::GCHandle _callBack;

		public:
			AudioMasterCallBack();
			virtual ~AudioMasterCallBack();
		protected:
			!AudioMasterCallBack();

		private:
			System::IntPtr AudioMasterCallBackProc(
				System::IntPtr/*AEffect^*/		effect,
				Interop::Vst::AudioMasterOpcodes	opcode,
				System::Int32		index,
				System::IntPtr		value,
				System::IntPtr		ptr,
				System::Single		opt
			);
			void DoEvent(System::Object^ args);

		public:
			Interop::Vst::AudioMasterCallBack::Delegate^ GetAudioMasterCallBackProc();

			event System::EventHandler<Interop::Vst::AudioMasterCallBack::AudioMasterEventArgs^>^ OnEvent;
		};

		System::String^	_library;
		Interop::Kernel32::Function::DynamicLinkLibrary^	_dll;

		AudioMasterCallBack^					_callBack;

		System::IntPtr							_aeffectPtr;
		Interop::Vst::AEffect^					_aeffect;
		Interop::Vst::AEffectDispatcherProc^	_dispatcher;
		Interop::Vst::AEffectSetParameterProc^	_setParameter;
		Interop::Vst::AEffectGetParameterProc^	_getParameter;
		Interop::Vst::AEffectProcessProc^		_processReplacing;
		Interop::Vst::AEffectProcessDoubleProc^	_processDoubleReplacing;

		Interop::Vst::VstTimeInfo^				_timeInfo;
		InteropServices::GCHandle				_timeInfoHandle;

	public:
		Master(System::String^ library);
		virtual ~Master();
	protected:
		!Master();

	private:
		void Open();
		void Close();
	public:

		System::Int32 GetNumPrograms()	{ return this->_aeffect->numPrograms; };
		System::Int32 GetNumParams()	{ return this->_aeffect->numParams; };
		System::Int32 GetNumInputs()	{ return this->_aeffect->numInputs; };
		System::Int32 GetNumOutputs()	{ return this->_aeffect->numOutputs; };
		Interop::Vst::VstAEffectFlags GetFlags()		{ return this->_aeffect->flags; };
		System::Int32 GetInitialDelay()	{ return this->_aeffect->initialDelay; };
		System::Int32 GetUniqueID()		{ return this->_aeffect->uniqueID; };
		System::Int32 GetVersion()		{ return this->_aeffect->version; };

	private:
		System::String^ GetString(Interop::Vst::AEffectOpcodes, System::Int32 index, System::Int32 length);

	public:
		//State Transitions
		void Suspend();	//< Called when plug-in is switched to off
		void Resume();	//< Called when plug-in is switched to on

		//Processing
		void SetSampleRate(System::Single sampleRate);	//< Called when the sample rate changes (always in a suspend state)
		void SetBlockSize(System::Int32 blockSize); //< Called when the Maximun block size changes (always in a suspend state). Note that the sampleFrames in Process Calls could be smaller than this block size, but NOT bigger.
		
		//Parameters
		void SetParameter(System::Int32	index, System::Single value);	//< Called when a parameter changed
		System::Single GetParameter(System::Int32 index);	//< Return the value of the parameter with \e index
		bool CanParameterBeAutomated (System::Int32 index); //< Indicates if a parameter can be automated
		bool String2Parameter(System::Int32 index, System::String^ value); //< Convert a string representation to a parameter value
		Interop::Vst::VstParameterProperties^ GetParameterProperties(System::Int32 index); //< Return parameter properties

		//Programs and Persistence
		System::Int32 GetProgram(); //< Return the index to the current program
		void SetProgram(System::Int32 program); //< Set the current program to \e program
		void SetProgramName(System::String^ name); //< Stuff the name field of the current program with \e name. Limited to #kVstMaxProgNameLen.
		System::String^ GetProgramName(); //< Stuff \e name with the name of the current program. Limited to #kVstMaxProgNameLen.
		System::String^ GetParameterLabel(System::Int32 index); //< Stuff \e label with the units in which parameter \e index is displayed (i.e. "sec", "dB", "type", etc...). Limited to #kVstMaxParamStrLen.
		System::String^ GetParameterDisplay(System::Int32 index); //< Stuff \e text with a string representation ("0.5", "-3", "PLATE", etc...) of the value of parameter \e index. Limited to #kVstMaxParamStrLen.
		System::String^ GetParameterName(System::Int32 index); //< Stuff \e text with the name ("Time", "Gain", "RoomType", etc...) of parameter \e index. Limited to #kVstMaxParamStrLen.
/*
		System::Int32 GetChunk(void** data, bool isPreset); //< Host stores plug-in state. Returns the size in bytes of the chunk (plug-in allocates the data array)
		System::Int32 SetChunk(void* data, System::Int32 byteSize, bool isPreset); //< Host restores plug-in state
*/
		System::String^ GetProgramNameIndexed(System::Int32 index); //< Fill \e text with name of program \e index (\e category deprecated in VST 2.4)
		bool BeginSetProgram (); //< Called before a program is loaded
		bool EndSetProgram (); //< Called after a program was loaded
/*
		System::Int32 BeginLoadBank (VstPatchChunkInfo* ptr); //< Called before a Bank is loaded.
		System::Int32 BeginLoadProgram (VstPatchChunkInfo* ptr); //< Called before a Program is loaded. (called before #beginSetProgram).
*/
		//Connections and Configuration
		Interop::Vst::VstPinProperties^ GetInputProperties(System::Int32 index); //< Return the \e properties of output \e index
		Interop::Vst::VstPinProperties^ GetOutputProperties(System::Int32 index);//< Return the \e properties of input \e index
/*
		bool SetSpeakerArrangement (VstSpeakerArrangement* pluginInput, VstSpeakerArrangement* pluginOutput); //< Set the plug-in's speaker arrangements
		bool GetSpeakerArrangement (VstSpeakerArrangement** pluginInput, VstSpeakerArrangement** pluginOutput); //< Return the plug-in's speaker arrangements
		bool SetBypass (bool onOff);//< For 'soft-bypass' (this could be automated (in Audio Thread) that why you could NOT call iochanged (if needed) in this function, do it in fxidle).
		bool SetPanLaw (System::Int32 type, System::Single val);//< Set the Panning Law used by the Host @see VstPanLawType.
		bool SetProcessPrecision (System::Int32 precision);//< Set System::Singleing-point precision used for processing (32 or 64 bit)
		System::Int32 GetNumMidiInputChannels();//< Returns number of MIDI input channels used [0, 16]
		System::Int32 GetNumMidiOutputChannels();//< Returns number of MIDI output channels used [0, 16]
*/

		//Realtime
		System::IntPtr GetTimeInfo(System::Int32 filter);	//< Get time information from Host
		//System::Int32 GetCurrentProcessLevel();			//< Returns the Host's process level
		//System::Int32 GetAutomationState();				//< Returns the Host's automation state
		System::Int32 ProcessEvents(array<Interop::Vst::VstEvent>^ events);	//< Called when new MIDI events come in
		System::Int32 StartProcess();		//< Called one time before the start of process call. This indicates that the process call will be interrupted (due to Host reconfiguration or bypass state when the plug-in doesn't support softBypass)
		System::Int32 StopProcess();		//< Called after the stop of process call
/*
		//Variable I/O (Offline)
		bool ProcessVariableIo (VstVariableIo* varIo); //< Used for variable I/O processing (offline processing like timestreching)
		System::Int32 SetTotalSampleToProcess (System::Int32 value); //< Called in offline mode before process() or processVariableIo ()

		//Host Properties
		bool GetHostVendorString (System::String^ text);	//< Fills \e text with a string identifying the vendor
		bool GetHostProductString (System::String^ text);	//< Fills \e text with a string with product name
		System::Int32 GetHostVendorVersion ();		//< Returns vendor-specific version (for example 3200 for Nuendo 3.2)
		System::IntPtr HostVendorSpecific (System::Int32 lArg1, System::IntPtr lArg2, void* ptrArg, System::Single System::SingleArg);	//< No specific definition
		System::Int32 CanHostDo (System::String^ text);		//< Reports what the Host is able to do (#hostCanDos in audioeffectx.cpp)
		System::Int32 GetHostLanguage ();			//< Returns the Host's language (#VstHostLanguage)

		//Plug-in Properties
		void IsSynth (bool state);		//< Set if plug-in is a synth
		void NoTail (bool state);		//< Plug-in won't produce output signals while there is no input
		System::Int32 GetGetTailSize () ; //< Returns tail size; 0 is default (return 1 for 'no tail'), used in offline processing too
		void* GetDirectory ();					//< Returns the plug-in's directory
*/
		System::String^ GetEffectName(); //< Fill \e text with a string identifying the effect
		System::String^ GetVendorString(); //< Fill \e text with a string identifying the vendor
		System::String^ GetProductString(); //< Fill \e text with a string identifying the product name
/*		System::Int32 GetVendorVersion (); //< Return vendor-specific version
		System::IntPtr VendorSpecific (System::Int32 lArg, System::IntPtr lArg2, void* ptrArg, System::Single System::SingleArg); //< No definition, vendor specific handling
		System::Int32 CanDo (System::String^ text); //< Reports what the plug-in is able to do (#plugCanDos in audioeffectx.cpp)
		System::Int32 GetVstVersion (); //< Returns the current VST Version (#kVstVersion)
		VstPlugCategory GetPlugCategory ();		//< Specify a category that fits the plug (#VstPlugCategory)
		
		//MIDI Channel Programs
		System::Int32 GetMidiProgramName (System::Int32 channel, MidiProgramName* midiProgramName); //< Fill \e midiProgramName with information for 'thisProgramIndex'.
		System::Int32 GetCurrentMidiProgram (System::Int32 channel, MidiProgramName* currentProgram); //< Fill \e currentProgram with information for the current MIDI program.
		System::Int32 GetMidiProgramCategory (System::Int32 channel, MidiProgramCategory* category); //< Fill \e category with information for 'thisCategoryIndex'.
		bool HasMidiProgramsChanged (System::Int32 channel); //< Return true if the #MidiProgramNames, #MidiKeyNames or #MidiControllerNames had changed on this MIDI channel.
		bool GetMidiKeyName (System::Int32 channel, MidiKeyName* keyName); //< Fill \e keyName with information for 'thisProgramIndex' and 'thisKeyNumber'

		//Others
		bool UpdateDisplay (); //< Something has changed in plug-in, request an update display like program (MIDI too) and parameters list in Host
		bool SizeWindow (System::Int32 width, System::Int32 height);	//< Requests to resize the editor window
		bool OpenFileSelector (VstFileSelect* ptr);			//< Open a Host File selector (see aeffectx.h for #VstFileSelect definition)
		bool CloseFileSelector (VstFileSelect* ptr);		//< Close the Host File selector which was opened by #openFileSelector
		System::Int32 GetNextShellPlugin (System::String^ name); //< This opcode is only called, if the plug-in is of type #kPlugCategShell, in order to extract all included sub-plugin・ｴs names.

		//Tools
		bool AllocateArrangement (VstSpeakerArrangement** arrangement, System::Int32 nbChannels);//< Allocate memory for a #VstSpeakerArrangement
		bool DeallocateArrangement (VstSpeakerArrangement** arrangement);			//< Delete/free memory for an allocated speaker arrangement
		bool CopySpeaker (VstSpeakerProperties* to, VstSpeakerProperties* from);	//< Copy properties \e from to \e to
		bool MatchArrangement (VstSpeakerArrangement** to, VstSpeakerArrangement* from);	//< "to" is deleted, then created and initialized with the same values as "from" ones ("from" must exist).

		// Offline
		bool OfflineRead (VstOfflineTask* offline, VstOfflineOption option, bool readSource = true);
		bool OfflineWrite (VstOfflineTask* offline, VstOfflineOption option);
		bool OfflineStart (VstAudioFile* ptr, System::Int32 numAudioFiles, System::Int32 numNewAudioFiles);
		System::Int32 OfflineGetCurrentPass ();
		System::Int32 OfflineGetCurrentMetaPass ();
		bool OfflineNotify (VstAudioFile* ptr, System::Int32 numAudioFiles, bool start);
		bool OfflinePrepare (VstOfflineTask* offline, System::Int32 count);
		bool OfflineRun (VstOfflineTask* offline, System::Int32 count);
		System::Int32 OfflineGetNumPasses ();
		System::Int32 OfflineGetNumMetaPasses ();
*/

	public:
		System::IntPtr Dispatcher(
			Interop::Vst::AEffectOpcodes	opcode,
			System::Int32	index,
			System::IntPtr	value,
			System::IntPtr	ptr,
			System::Single	opt
		);

		void Process(
			Buffer::VstBuffer<System::Single>^ inputs,
			Buffer::VstBuffer<System::Single>^ outputs,
			System::Int32	sampleFrames
		);

		void Process(
			Buffer::VstBuffer<System::Double>^ inputs,
			Buffer::VstBuffer<System::Double>^ outputs,
			System::Int32	sampleFrames
		);

	private:
		void OnEventHandler(System::Object^ sender, Interop::Vst::AudioMasterCallBack::AudioMasterEventArgs^ args);

	};

	public ref class VstException
		: public System::Exception
	{
	public:
		VstException(System::String^ v): System::Exception(v){};
	};

}
}
}
}
