﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Vst.Buffer.h
	buffer for VST.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Vst {
namespace Buffer {

	///<summary></summary>
	///
	///
	///
	generic<typename T>
	public ref class VstBuffer {
	private:
		array<array<T>^>^ _buffer;
		array<InteropServices::GCHandle>^ _channelBufferHandles;
		InteropServices::GCHandle _bufferHandle;

	public:
		VstBuffer(System::Int32 channel, System::Int32 size);
		virtual ~VstBuffer();

	protected:
		!VstBuffer();

	private:
		void Alloc(System::Int32 channel, System::Int32 size);
		void Free();

	public:
		System::IntPtr AddrOfPinnedObject()
		{
			return _bufferHandle.AddrOfPinnedObject();
		}

		System::Int32 Length()
		{
			return this->_buffer[0]->Length;
		}

		array<array<T>^>^ GetBuffer()
		{
			return this->_buffer;
		}

		void Reset(array<array<T>^>^ data);
	};
}
}
}
}
