﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Timer.MMTimer.cpp
	timer component. multi media timer version.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#include "StdAfx.h"

#include "Momiji.Interop.Winmm.h"
#include "Momiji.Core.Timer.MMTimer.h"

namespace Momiji {
namespace Core {
namespace Timer {

	void MMTimer::OnEventHandler(
		System::Object^ sender, 
		Interop::Winmm::TimerCallBack::TimerEventArgs^ args
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] [{1}] start", __FUNCTION__, System::Threading::Thread::CurrentThread->GetHashCode());
		#endif

		this->DoInterval(args->dw1, args->dw2);

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] [{1}] end", __FUNCTION__, System::Threading::Thread::CurrentThread->GetHashCode());
		#endif
	};

	void MMTimer::DoInterval(System::IntPtr dw1, System::IntPtr dw2)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		System::Double deltaTime = 
			(1000.0 * safe_cast<System::Double>(this->_stopWatch->ElapsedTicks)) / safe_cast<System::Double>(this->_stopWatch->Frequency);
		this->_stopWatch->Restart();
		this->OnInterval(deltaTime);

		/*
		System::UInt32 nowTime = Interop::Winmm::Function::timeGetTime();
		System::UInt32 deltaTime = (nowTime - this->_beforeTime);

		if (this->_beforeTime > nowTime)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] オーバーフロー分を調整",__FUNCTION__);
			#endif
			deltaTime = nowTime + (System::UInt32::MaxValue - this->_beforeTime);
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] deltaTime {1}", __FUNCTION__, deltaTime);
		#endif

		if (deltaTime == 0)
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] 時差が０なのでスキップ",__FUNCTION__);
			#endif
			// NOP
		}
		else
		{
			this->OnInterval(nowTime - this->_beforeTime);
		}

		this->_beforeTime = nowTime;
		*/
	}

	Interop::Winmm::TimeCapabilities^ MMTimer::getCapabilities()
	{
		auto caps = gcnew Interop::Winmm::TimeCapabilities();
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] caps size {1}",__FUNCTION__, InteropServices::Marshal::SizeOf(caps));
		#endif
		auto mmResult = 
			Interop::Winmm::Function::timeGetDevCaps(
				caps, 
				InteropServices::Marshal::SizeOf(caps)
			);
		if (mmResult != Interop::Winmm::MMRESULT::NOERROR)
		{
			throw gcnew MMTimerException(mmResult);
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] min {1}, max {2}",__FUNCTION__, caps->periodMin, caps->periodMax);
		#endif

		return caps;
	}

	MMTimer::MMTimer(): _timerID(0)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
	}

	MMTimer::~MMTimer()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!MMTimer();
	}

	MMTimer::!MMTimer()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->Stop();
	}

	void MMTimer::Start(
		System::UInt32 period	
	)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		auto caps = getCapabilities();
		if (period < caps->periodMin) period = caps->periodMin;
		if (period > caps->periodMax) period = caps->periodMax;
		/*
		{
			Winmm::MMRESULT mmResult = Winmm::Function::timeBeginPeriod(period);
			if (mmResult != Winmm::MMRESULT::NOERROR) {
				throw gcnew Exception(mmResult);
			}
		}
		*/

		{
			//イベントは同期で動かす
			//非同期にすると、
			//・タイマー間隔が短い場合、順序性が保証できない
			//・コンテキストスイッチが重くなる
			this->_callBack = gcnew Core::Winmm::TimerCallBack(false); 
			this->_callBack->OnEvent += gcnew System::EventHandler<Interop::Winmm::TimerCallBack::TimerEventArgs^>(this, &MMTimer::OnEventHandler);

			//this->_beforeTime = Interop::Winmm::Function::timeGetTime();
			this->_stopWatch = System::Diagnostics::Stopwatch::StartNew();

			this->_timerID = 
				Interop::Winmm::Function::timeSetEvent(
					period,
					caps->periodMin,
					this->_callBack->GetTimerCallBackProc(),
					System::IntPtr::Zero,
					(
						Interop::Winmm::TimerCallBack::TYPE::PERIODIC
					//	Interop::Winmm::TimerCallBack::TYPE::ONESHOT
					|	Interop::Winmm::TimerCallBack::TYPE::CALLBACK_FUNCTION
					|	Interop::Winmm::TimerCallBack::TYPE::KILL_SYNCHRONOUS
					)
				);
			if (this->_timerID == 0)
			{
				this->Stop();
			}
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] timerID {1:X}",__FUNCTION__, this->_timerID);
		#endif
	}

	void MMTimer::Stop()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] timerID {1:X}",__FUNCTION__, this->_timerID);
		#endif

		if (this->_timerID != 0)
		{
			auto mmResult = Interop::Winmm::Function::timeKillEvent(this->_timerID);
			if (
					(mmResult != Interop::Winmm::MMRESULT::NOERROR)
				&&	(mmResult != Interop::Winmm::MMRESULT::TIMERR_NOCANDO) //タイマが起動されていない状態も無視する
			)
			{
				throw gcnew MMTimerException(mmResult);
			}
			this->_timerID = 0;
		}
		else
		{
			#ifdef _DEBUG
				System::Console::WriteLine("[{0}] startしていない状態なので、無視します。",__FUNCTION__);
			#endif
		}

		if (this->_callBack != nullptr)
		{
			delete this->_callBack;
		}
	}

	System::String^ MMTimerException::Initialize()
	{
		return "エラーコード[" + this->_mmResult.ToString("D") + "]";
	}

}
}
}
