﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Midi.In.h
	midi input component.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
#include "Momiji.Core.Winmm.h"
#include "Momiji.Core.Buffer.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Midi {
namespace In {

	public ref class Device
	{
	private:
		initonly System::UInt32				_deviceID;
		Interop::Winmm::Function::MidiIn^	_handle;
		Core::Winmm::DriverCallBack^		_callBack;
		Core::Buffer::BufferPool<Interop::Winmm::MidiHeader^>^ _headerPool;
		Core::Buffer::BufferPool<array<System::Byte>^>^ _bufferPool;

	public:
		Device(const System::UInt32 deviceID);
		virtual ~Device();
	protected:
		!Device();

	private:
		System::IntPtr Prepare();
		void Unprepare(System::IntPtr headerPtr);

		Interop::Winmm::MidiHeader^ AllocateHeader();
		array<System::Byte>^ AllocateBuffer();

	public:
		static System::UInt32 GetNumDevices();
		static Interop::Winmm::MidiInCapabilities^ GetCapabilities(const System::UInt32 uDeviceID);
		Interop::Winmm::MidiInCapabilities^ GetCapabilities();

	private:
		void Open();
		void Close();

	public:
		event System::EventHandler<System::EventArgs^>^ OnOpen;
		event System::EventHandler<System::EventArgs^>^ OnClose;

		delegate void ShortEvent(System::UInt32 data, System::UInt32 time);
		event ShortEvent^ OnData;

		delegate void LongEvent(array<System::Byte>^ data, System::UInt32 time);
		event LongEvent^ OnLongData;
		event LongEvent^ OnMoreData;

	private:
		void OnEventHandler(System::Object^ sender, Interop::Winmm::DriverCallBack::DriverEventArgs^ args);
		void DoOpen(System::IntPtr dwParam1, System::IntPtr dwParam2);
		void DoClose(System::IntPtr dwParam1, System::IntPtr dwParam2);

		void DoData(System::IntPtr dwParam1, System::IntPtr dwParam2);
		void DoError(System::IntPtr dwParam1, System::IntPtr dwParam2);

		void DoLongData(System::IntPtr dwParam1, System::IntPtr dwParam2);
		void DoLongError(System::IntPtr dwParam1, System::IntPtr dwParam2);
		void DoMoreData(System::IntPtr dwParam1, System::IntPtr dwParam2);
	};

	public ref class MidiInException: System::Exception
	{
	private:
		initonly Interop::Winmm::MMRESULT _mmResult;
		System::String^ Initialize();

	public:
		MidiInException(Interop::Winmm::MMRESULT v): _mmResult(v), System::Exception(Initialize()){};
		MidiInException(System::String^ v): System::Exception(v){};
		virtual ~MidiInException(void){};

		property Interop::Winmm::MMRESULT mmResult
		{
			Interop::Winmm::MMRESULT get(void) {return this->_mmResult;};
		}
	};
}
}
}
}
