﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Midi.Data.h
	midi data.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

#include "Momiji.Interop.Winmm.h"
#include "Momiji.Core.Interface.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Midi {

	public ref class MidiData abstract
		: public Core::IData
	{
	private:
		initonly System::UInt16	_port;

	protected:
		MidiData(
			System::UInt16	port
		): _port(port){}

	public:
		enum class TYPE: System::Byte
		{
			NOTE_OFF				= 0x80,	// {8x 128..143  | nn vv |  n:note num; v:velocity}
			NOTE_ON					= 0x90,	// {9x 144..159  | nn vv |  n:note num; v:velocity}
			POLYHONIC_KEY_PRESSURE	= 0xA0,	// {Ax 160..176  | nn vv |  n:note num; v:velocity}
			CONTROL_CHANGE			= 0xB0,	// {Bx 176..191  | cc vv |  n:ctrl num; v:value}
			PROGRAM_CHANGE			= 0xC0,	// {Cx 192..207  | pp    |  p:prog num}
			CNANNEL_PRESSURE		= 0xD0,	// {Dx 208..223  | cc    |  c:chan num}
			PITCH_WHILE_CHANGE		= 0xE0,	// {Ex 224..239  | ll mm |  l:least sig; m:most sig}
									            //{center   2000H}
			SYSTEM_MESSAGE			= 0xF0,
			SYSTEM_EXCLUSIVE		= 0xF0,
			META					= 0xFF,
		};

		property System::UInt16 port { System::UInt16 get() {return this->_port;} }
	};

	public ref class ShortData
		: public MidiData
	{
	private:
		initonly System::Byte	_param1;
		initonly System::Byte	_param2;
		initonly System::Byte	_status;

	public:
		ShortData(
			System::UInt16	port,
			System::Byte	status,
			System::Byte	param1,
			System::Byte	param2
		): MidiData(port), _status(status), _param1(param1), _param2(param2) {}

		property System::Byte status { System::Byte get() {return this->_status;} }
		property System::Byte param1 { System::Byte get() {return this->_param1;} }
		property System::Byte param2 { System::Byte get() {return this->_param2;} }
		property System::UInt32 shortData
		{
			System::UInt32 get()
			{
				return (
					this->status |
					(this->param1 << 8) |
					(this->param2 << 16)
				);
			}
		}
	};

	public ref class LongData
		: public MidiData
	{
	private:
		initonly array<System::Byte>^	_longData;
		initonly System::UInt32 _useSize;

	public:
		LongData(
			System::UInt16			port,
			array<System::Byte>^	longData,
			System::UInt32			useSize
		): MidiData(port), _longData(longData), _useSize(useSize) {}

		property array<System::Byte>^ longData { array<System::Byte>^ get() {return this->_longData;} }
		property System::UInt32 useSize { System::UInt32 get() { return this->_useSize; } }
	};

}
}
}
