﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Ks.h
	kernel streaming
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

#include "Momiji.Interop.Guiddef.h"
#include "Momiji.Interop.Ks.h"
#include "Momiji.Core.Buffer.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Ks {

	ref class Overlapped
	{
	private:
		System::Threading::EventWaitHandle^	_waitHandle;
		System::Threading::NativeOverlapped	_overlapped;
		InteropServices::GCHandle			_overlappedHandle;

	public:
		Overlapped();
		virtual ~Overlapped();
	protected:
		!Overlapped();

	public:
		void Reset();

	public:
		property System::Threading::NativeOverlapped% overlapped
		{
			System::Threading::NativeOverlapped% get() { return this->_overlapped; }
		}

		property System::Boolean pendding
		{
			System::Boolean get() { return !this->_waitHandle->WaitOne(0); }
		}
	};


	ref class Irp abstract
	{
	private:
		initonly Interop::Kernel32::Function::File^	_handle;
		
	public:
		Irp();
		virtual ~Irp();
	protected:
		!Irp();

	protected:
		virtual Interop::Kernel32::Function::File^ Open() abstract;

	public:
		property Interop::Kernel32::Function::File^ handle
		{
			Interop::Kernel32::Function::File^ get() { return this->_handle; }
		}

	private:
		void Close();

	public:
		System::UInt32 IOSync(
			Interop::Ks::IOCTL_KS ioControlCode,
			System::IntPtr inBuffer,
			System::UInt32 inBufferSize,
			System::IntPtr outBuffer,
			System::UInt32 outBufferSize,
			System::UInt32% bytesReturned
		);
		
		generic<typename IN>
		System::UInt32 IOSync(
			Interop::Ks::IOCTL_KS ioControlCode,
			IN% in,
			System::IntPtr outBuffer,
			System::UInt32 outBufferSize,
			System::UInt32% bytesReturned
		);
		
		generic<typename IN, typename OUT>
		System::UInt32 IOSync(
			Interop::Ks::IOCTL_KS ioControlCode,
			IN% in,
			OUT% out
		);
		
		//System::Tupleを使うとコンパイルエラー（C2440）が出るので、仕方なく定義
		generic<typename T>
		ref class Tuple
		{
		public:
			T value;
			Tuple(T v): value(v) {};
		};

		generic<typename IN, typename OUT>
		Tuple<OUT>^ GetSingle(
			Interop::Ks::IOCTL_KS ioControlCode,
			IN% in
		);

		generic<typename IN>
		System::UInt32 Put(
			Interop::Ks::IOCTL_KS ioControlCode,
			IN% in,
			System::UInt32% bytesReturned
		);

		generic<typename IN, typename OUT>
		array<OUT>^ GetMultiple(
			Interop::Ks::IOCTL_KS ioControlCode,
			IN% in
		);

		generic<typename IN, typename OUT>
		array<OUT>^ GetArray(
			Interop::Ks::IOCTL_KS ioControlCode,
			IN% in
		);
	};





}
}
}
