﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Ks.PropertySet.h
	kernel streaming
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

#include "Momiji.Interop.Guiddef.h"
#include "Momiji.Interop.Ks.h"

#include "Momiji.Core.Ks.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Ks {

	public ref class PropertySet abstract
	{
	private:
		initonly Irp^ _irp;
			
	internal:
		PropertySet(Irp^ irp): _irp(irp) {};
		
		property Irp^ irp
		{
			Irp^ get() { return this->_irp; }
		}
	};

	public ref class PropertySetTopology: PropertySet
	{
	internal:
		PropertySetTopology(
			Irp^ irp
		);
	};
	
	public ref class PropertySetAudio: PropertySet
	{
	internal:
		PropertySetAudio(
			Irp^ irp
		);
	};

	public ref class PropertySetPin: PropertySet
	{
	public:
		ref class Item
		{
		private:
			initonly PropertySet^ _propertySet;
			initonly System::UInt32 _pinId;

			array<Interop::Ks::KsPinInterface>^		_interfaces;
			array<Interop::Ks::KsPinMedium>^		_mediums;
			array<Interop::Ks::KsDataFormat>^		_dataFormats;
			Interop::Ks::KsPinDataFlow::ENUM		_dataflow;
			Interop::Ks::KsPinCommunication::ENUM	_communication;
			Interop::Guiddef::Guid					_category;
			System::String^							_name;
			//array<Interop::Ks::KsDataFormat^>^	_constrainedDataRanges;

			Interop::Ks::KsCInstances^				_instances;
			Interop::Ks::KsCInstances^				_globalInstances;

		internal:
			Item(
				PropertySet^ propertySet,
				System::UInt32 pinId
			);

		public:
			property System::UInt32 pinId
			{
				System::UInt32 get() { return this->_pinId; }
			}

			property PropertySet^ propertySet
			{
				PropertySet^ get() { return this->_propertySet; }
			}
		};

	private:
		array<Item^>^	_items;

	internal:
		PropertySetPin(
			Irp^ irp
		);

	public:
		property array<Item^>^ Items { array<Item^>^ get() { return this->_items; } };
	};

}
}
}
