﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Ks.PropertySet.cpp
	kernel streaming.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#include "StdAfx.h"
//#include "Momiji.Core.Ks.h"
//#include "Momiji.Interop.Kernel32.h"
//#include "Momiji.Interop.Ks.h"
#include "Momiji.Core.Ks.Filter.h"

namespace Momiji {
namespace Core {
namespace Ks {


	PropertySetTopology::PropertySetTopology(
		Irp^ irp
	):
		PropertySet(irp)
	{
		auto param = Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_TOPOLOGY, Interop::Ks::PROPERTY_TYPE>();
		param.Set		= Interop::Ks::StaticKs::PROPSETID_Topology;
		param.Flags	= Interop::Ks::PROPERTY_TYPE::GET;

		{
			param.Id		= Interop::Ks::PROPERTY_ID_TOPOLOGY::CATEGORIES;
			auto v = this->irp->GetMultiple<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_TOPOLOGY, Interop::Ks::PROPERTY_TYPE>, Interop::Guiddef::Guid>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				//this->_instances = v->value;

				auto nodeParam = Interop::Ks::KsNode<Interop::Ks::PROPERTY_ID_TOPOLOGY, Interop::Ks::PROPERTY_TYPE>();
				nodeParam.Property.Set		= Interop::Ks::StaticKs::PROPSETID_Topology;
				nodeParam.Property.Id		= Interop::Ks::PROPERTY_ID_TOPOLOGY::NAME;
				nodeParam.Property.Flags	= Interop::Ks::PROPERTY_TYPE::GET;

				auto i = 0;
				for each (Interop::Guiddef::Guid g in v)
				{
					nodeParam.NodeId = i++;
					auto n = this->irp->GetSingle<Interop::Ks::KsNode<Interop::Ks::PROPERTY_ID_TOPOLOGY, Interop::Ks::PROPERTY_TYPE>, Interop::Ks::KsName>(Interop::Ks::IOCTL_KS::PROPERTY, nodeParam);

				}
			}
		}
		{
			param.Id		= Interop::Ks::PROPERTY_ID_TOPOLOGY::NODES;
			auto v = this->irp->GetMultiple<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_TOPOLOGY, Interop::Ks::PROPERTY_TYPE>, Interop::Guiddef::Guid>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				//this->_instances = v->value;
			}
		}
		{
			param.Id		= Interop::Ks::PROPERTY_ID_TOPOLOGY::CONNECTIONS;
			auto v = this->irp->GetMultiple<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_TOPOLOGY, Interop::Ks::PROPERTY_TYPE>, Interop::Ks::KsTopologyConnection>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				//this->_instances = v->value;
			}
		}
	}

	PropertySetAudio::PropertySetAudio(
		Irp^ irp
	):
		PropertySet(irp)
	{
		auto param = Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_AUDIO, Interop::Ks::PROPERTY_TYPE>();
		param.Set		= Interop::Ks::StaticKs::PROPSETID_Audio;
		param.Flags	= Interop::Ks::PROPERTY_TYPE::GET;

		{
			param.Id		= Interop::Ks::PROPERTY_ID_AUDIO::LATENCY;
			auto v = this->irp->GetMultiple<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_AUDIO, Interop::Ks::PROPERTY_TYPE>, Interop::Ks::KsTime>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				//this->_instances = v->value;
			}
		}
	}



	PropertySetPin::PropertySetPin(
		Irp^ irp
	):
		PropertySet(irp)
	{
		auto itemList = gcnew System::Collections::Generic::List<Item^>;

		auto param = Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID, Interop::Ks::PROPERTY_TYPE>();
		param.Set		= Interop::Ks::StaticKs::PROPSETID_Pin;
		param.Id		= Interop::Ks::PROPERTY_ID::CTYPES;
		param.Flags	= Interop::Ks::PROPERTY_TYPE::GET;

		auto ctypes = 
			this->irp->GetSingle<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID, Interop::Ks::PROPERTY_TYPE>, System::UInt32>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		for (System::UInt32 idx = 0; idx < ctypes->value; idx++)
		{
			itemList->Add(gcnew Item(this, idx));
		}

		this->_items = itemList->ToArray();
	}

	PropertySetPin::Item::Item(
		PropertySet^ propertySet,
		System::UInt32 pinId
	):
		_propertySet(propertySet),
		_pinId(pinId),
		_communication(Interop::Ks::KsPinCommunication::ENUM::NONE),
		_dataflow(Interop::Ks::KsPinDataFlow::ENUM::NONE),
		_interfaces(nullptr),
		_mediums(nullptr),
		_dataFormats(nullptr),
		_instances(nullptr),
		_globalInstances(nullptr),
		//_category(nullptr),
		_name(nullptr)
	{
		auto param = Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>();
		param.Property.Set		= Interop::Ks::StaticKs::PROPSETID_Pin;
		param.Property.Flags	= Interop::Ks::PROPERTY_TYPE::GET;
		param.PinId			= this->_pinId;
		param.Reserved			= 0;

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::CINSTANCES;
			auto v = this->propertySet->irp->GetSingle<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsCInstances>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				this->_instances = v->value;
			}
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::DATAFLOW;
			auto v = this->propertySet->irp->GetSingle<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsPinDataFlow>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				this->_dataflow = v->value.Value;
			}
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::DATARANGES;
			this->_dataFormats	= this->propertySet->irp->GetMultiple<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsDataFormat>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		}

		{//TODO PPIN + MultipleItem + (DataFormat * n) がINパラメータでなければならない。データ変換結果を取得できるのかな？？
			param.Property.Id	= Interop::Ks::PROPERTY_ID::DATAINTERSECTION;
			this->propertySet->irp->GetSingle<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsCInstances>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::INTERFACES;
			this->_interfaces	= this->propertySet->irp->GetMultiple<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsPinInterface>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::MEDIUMS;
			this->_mediums		= this->propertySet->irp->GetMultiple<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsPinMedium>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::COMMUNICATION;
			auto v = this->propertySet->irp->GetSingle<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsPinCommunication>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				this->_communication = v->value.Value;
			}
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::GLOBALCINSTANCES;
			auto v = this->propertySet->irp->GetSingle<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsCInstances>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				this->_globalInstances = v->value;
			}
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::NECESSARYINSTANCES;
			this->propertySet->irp->GetSingle<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsCInstances>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::PHYSICALCONNECTION;
			this->propertySet->irp->GetSingle<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsCInstances>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::CATEGORY;
			auto v = this->propertySet->irp->GetSingle<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Guiddef::Guid>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				this->_category = v->value;
			}
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::NAME;
			auto v = this->propertySet->irp->GetSingle<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsName>(Interop::Ks::IOCTL_KS::PROPERTY, param);
			if (v != nullptr)
			{
				this->_name = v->value.Name;
			}
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::CONSTRAINEDDATARANGES;
			this->propertySet->irp->GetMultiple<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsDataFormat>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		}

		{
			param.Property.Id	= Interop::Ks::PROPERTY_ID::PROPOSEDATAFORMAT;
			this->propertySet->irp->GetMultiple<Interop::Ks::KsPropertyPin<Interop::Ks::PROPERTY_ID>, Interop::Ks::KsDataFormat>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		}
	}


}
}
}
