﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Ks.Pin.h
	kernel streaming
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

#include "Momiji.Interop.Guiddef.h"
#include "Momiji.Interop.Ks.h"
#include "Momiji.Core.Ks.h"
#include "Momiji.Core.Ks.PropertySet.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Ks {

	ref class PinHandle: Irp
	{
	private:
		initonly PropertySetPin::Item^	_item;
		System::UInt16					_channels;
		System::UInt32					_samplesPerSecond;
		System::UInt16					_bitsPerSample;

		Interop::Winmm::WaveFormatExtensiblePart::SPEAKER	_channelMask;
		Interop::Guiddef::Guid	_formatSubType;

	public:
		PinHandle(
			PropertySetPin::Item^ item,
			System::UInt16 channels,
			System::UInt32 samplesPerSecond,
			System::UInt16 bitsPerSample,
			Interop::Winmm::WaveFormatExtensiblePart::SPEAKER	channelMask,
			Interop::Guiddef::Guid formatSubType
		);
		virtual ~PinHandle();

	protected:
		!PinHandle();

	protected:
		virtual Interop::Kernel32::Function::File^ Open() override;
	};


	generic<typename T>
	public ref class Pin
	{
		initonly PinHandle^ _handle;
		Core::Buffer::BufferPool<Interop::Ks::KsStreamHeader>^ _headerPool;

	public:
		Pin(
			PropertySetPin::Item^ item,
			System::UInt16 channels,
			System::UInt32 samplesPerSecond,
			System::UInt16 bitsPerSample,
			Interop::Winmm::WaveFormatExtensiblePart::SPEAKER	channelMask,
			Interop::Guiddef::Guid formatSubType
		);
		virtual ~Pin();

	protected:
		!Pin();

	public:
		//void Send(array<T>^ data);
		void Reset();

		void Test();

	public:
		property Interop::Ks::KsState::ENUM	State
		{
			Interop::Ks::KsState::ENUM get();
			void set(Interop::Ks::KsState::ENUM v);
		};
	};

}
}
}
