﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Ks.Pin.cpp
	kernel streaming.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#include "StdAfx.h"
#include "Momiji.Core.Ks.Pin.h"

namespace Momiji {
namespace Core {
namespace Ks {

	PinHandle::PinHandle(
		PropertySetPin::Item^ item,
		System::UInt16 channels,
		System::UInt32 samplesPerSecond,
		System::UInt16 bitsPerSample,
		Interop::Winmm::WaveFormatExtensiblePart::SPEAKER	channelMask,
		Interop::Guiddef::Guid formatSubType
	):
		_item(item),
		_channels(channels),
		_samplesPerSecond(samplesPerSecond),
		_bitsPerSample(bitsPerSample),
		_channelMask(channelMask),
		_formatSubType(formatSubType),
		Irp()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] pinId {1}",__FUNCTION__, this->_item->pinId);
		#endif
	}

	PinHandle::~PinHandle()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] pinId {1}",__FUNCTION__, this->_item->pinId);
		#endif
		this->!PinHandle();
	}

	PinHandle::!PinHandle()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] pinId {1}",__FUNCTION__, this->_item->pinId);
		#endif
	}

	Interop::Kernel32::Function::File^ PinHandle::Open()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		auto connect = Interop::Ks::KsPinConnect();
		connect.Interface.Set              = Interop::Ks::StaticKs::INTERFACESETID_Standard;
		connect.Interface.Id               = Interop::Ks::KsPinInterface::ID::STANDARD_STREAMING;
		connect.Interface.Flags            = 0;

		connect.Medium.Set                 = Interop::Ks::StaticKs::MEDIUMSETID_Standard;
		connect.Medium.Id                  = Interop::Ks::KsPinMedium::ID::STANDARD_ANYINSTANCE;
		connect.Medium.Flags               = 0;

		connect.PinId                      = this->_item->pinId;
		connect.PinToHandle                = System::IntPtr::Zero;
		
		connect.Priority.PriorityClass     = Interop::Ks::KsPriority::CLASS::NORMAL;
		connect.Priority.PrioritySubClass  = 1;

		connect.DataFormat.FormatSize = 
			  InteropServices::Marshal::SizeOf(Interop::Ks::KsDataFormat::typeid) 
			+ InteropServices::Marshal::SizeOf(Interop::Winmm::WaveFormatExtensible::typeid)
			;
		connect.DataFormat.Flags		= 0;
		connect.DataFormat.SampleSize	= 0;
		connect.DataFormat.Reserved		= 0;
		connect.DataFormat.MajorFormat	= Interop::Ks::StaticKs::MEDIATYPE_Audio;
		connect.DataFormat.SubFormat	= Interop::Ks::StaticKs::SUBTYPE_PCM;
		connect.DataFormat.Specifier	= Interop::Ks::StaticKs::SPECIFIER_WAVEFORMATEX;

		connect.WaveFormat.wfe.formatType				= Interop::Winmm::WaveFormatEx::FORMAT::EXTENSIBLE;
		connect.WaveFormat.wfe.channels					= this->_channels;
		connect.WaveFormat.wfe.samplesPerSecond			= this->_samplesPerSecond;
		connect.WaveFormat.wfe.bitsPerSample			= this->_bitsPerSample;
		connect.WaveFormat.wfe.blockAlign				= connect.WaveFormat.wfe.channels * connect.WaveFormat.wfe.bitsPerSample / 8; 
		connect.WaveFormat.wfe.averageBytesPerSecond	= connect.WaveFormat.wfe.samplesPerSecond * connect.WaveFormat.wfe.blockAlign;
		connect.WaveFormat.wfe.size						= safe_cast<System::UInt16>(InteropServices::Marshal::SizeOf(Interop::Winmm::WaveFormatExtensiblePart::typeid));

		connect.WaveFormat.exp.validBitsPerSample		= connect.WaveFormat.wfe.bitsPerSample;	//TODO: 実際にハードウェアでサポートしている限界に揃える
		connect.WaveFormat.exp.channelMask				= this->_channelMask;
		connect.WaveFormat.exp.subFormat				= this->_formatSubType;


		System::Console::WriteLine("[{0}] create pin [{1}]",__FUNCTION__, connect);

		Interop::Kernel32::Function::File^ handle;

		auto error = 
			Interop::Ks::Function::KsCreatePin(
				this->_item->propertySet->irp->handle,
				connect,
				(
						Momiji::Interop::Kernel32::ACCESS_TYPES::GENERIC_READ 
					|	Momiji::Interop::Kernel32::ACCESS_TYPES::GENERIC_WRITE
				),
				handle
			);

		if (error != 0)
		{
			//HRESULTに変換
			error |= 0x80000000;
			error |= 7 << 16;
			InteropServices::Marshal::ThrowExceptionForHR(error);
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] Handle invalid:{1} closed:{2}",__FUNCTION__, handle->IsInvalid, handle->IsClosed);
		#endif

		return handle;
	}


	generic<typename T>
	Pin<T>::Pin(
		PropertySetPin::Item^ item,
		System::UInt16 channels,
		System::UInt32 samplesPerSecond,
		System::UInt16 bitsPerSample,
		Interop::Winmm::WaveFormatExtensiblePart::SPEAKER	channelMask,
		Interop::Guiddef::Guid formatSubType
	)
		: _handle(
			gcnew PinHandle(
				item, 
				channels,
				samplesPerSecond,
				bitsPerSample,
				channelMask,
				formatSubType
			)
		)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
	}

	generic<typename T>
	Pin<T>::~Pin()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!Pin();
	}

	generic<typename T>
	Pin<T>::!Pin()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->State = Interop::Ks::KsState::ENUM::STOP;
		this->Reset();
		delete this->_handle;
	}

	generic<typename T>
	void Pin<T>::Reset()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("=========================================================");
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		System::UInt32 bytesReturned = 0;
		auto reset = Interop::Ks::KsReset();

		{
			reset.Value = Interop::Ks::KsReset::ENUM::BEGIN;
			auto error =
				this->_handle->Put<Interop::Ks::KsReset>(
					Interop::Ks::IOCTL_KS::RESET_STATE,
					reset,
					bytesReturned
				);
			InteropServices::Marshal::ThrowExceptionForHR(error);
		}

		{
			reset.Value = Interop::Ks::KsReset::ENUM::END;
			auto error =
				this->_handle->Put<Interop::Ks::KsReset>(
					Interop::Ks::IOCTL_KS::RESET_STATE,
					reset,
					bytesReturned
				);
			InteropServices::Marshal::ThrowExceptionForHR(error);
		}
		#ifdef _DEBUG
			System::Console::WriteLine("=========================================================");
		#endif
	}

	generic<typename T>
	Interop::Ks::KsState::ENUM Pin<T>::State::get()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		auto param = Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_CONNECTION, Interop::Ks::PROPERTY_TYPE>();
		param.Set		= Interop::Ks::StaticKs::PROPSETID_Connection;
		param.Id		= Interop::Ks::PROPERTY_ID_CONNECTION::STATE;
		param.Flags	= Interop::Ks::PROPERTY_TYPE::GET;

		auto v = this->_handle->GetSingle<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_CONNECTION, Interop::Ks::PROPERTY_TYPE>, Interop::Ks::KsState>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		if (v != nullptr)
		{
			return v->value.Value;
		}
			
		return Interop::Ks::KsState::ENUM::STOP;
	}

	generic<typename T>
	void Pin<T>::State::set(Interop::Ks::KsState::ENUM v)
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		auto param = Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_CONNECTION, Interop::Ks::PROPERTY_TYPE>();
		param.Set		= Interop::Ks::StaticKs::PROPSETID_Connection;
		param.Id		= Interop::Ks::PROPERTY_ID_CONNECTION::STATE;
		param.Flags	= Interop::Ks::PROPERTY_TYPE::SET;

		auto state = Interop::Ks::KsState();
		state.Value = v;

		auto error = this->_handle->IOSync<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID_CONNECTION, Interop::Ks::PROPERTY_TYPE>, Interop::Ks::KsState>(Interop::Ks::IOCTL_KS::PROPERTY, param, state);
		InteropServices::Marshal::ThrowExceptionForHR(error);
	}

	value class A {
	public:
		static System::Single Modulus(System::Single dividend, System::Single divisor)
		{
			return
				safe_cast<System::Single>(
					(System::Math::Abs(dividend) - (System::Math::Abs(divisor) * 
					(System::Math::Floor(System::Math::Abs(dividend) / System::Math::Abs(divisor))))) * 
					System::Math::Sign(dividend)
				);
		}
	};

	generic<typename T>
	void Pin<T>::Test()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		this->State;
		this->Reset();
		if (this->State == Interop::Ks::KsState::ENUM::STOP)	{ this->State = Interop::Ks::KsState::ENUM::ACQUIRE; }
		if (this->State == Interop::Ks::KsState::ENUM::ACQUIRE)	{ this->State = Interop::Ks::KsState::ENUM::PAUSE; }
		if (this->State == Interop::Ks::KsState::ENUM::PAUSE)	{ this->State = Interop::Ks::KsState::ENUM::RUN; }
		this->State;

		System::UInt32 samplesPerSecond = 48000;

		if (!this->_handle->handle->IsInvalid && !this->_handle->handle->IsClosed)
		{
			System::UInt32 pulBytesReturned = 0;

			auto data = gcnew array<System::UInt16>(samplesPerSecond*4);

			for(System::Int32 idx = 0; idx < samplesPerSecond * 4; idx++)
			{
				System::UInt16 d = (System::Int16::MaxValue / 2);
				System::UInt16 ll = safe_cast<System::UInt16>(samplesPerSecond / (440 + ((440 / (samplesPerSecond * 2)) * idx)));

				if((idx % ll) < (ll / 2))
				//if(idx < (ll / 2))
				{
					d += System::UInt16::MaxValue / 440;
				}
				else
				{
					d -= System::UInt16::MaxValue / 440;
				}

				d = (d > System::UInt16::MaxValue) ? System::UInt16::MaxValue: d;
				d = (d < System::UInt16::MinValue) ? System::UInt16::MinValue: d;

				data[idx] = d;
			}

			/*
			for(System::UInt32 idx = 0; idx < s * 2; idx++)
			{
				System::Single d = .0;

				System::Single ll = safe_cast<System::Single>(s / (440.0 + ((440.0 / (s * 2)) * idx)));

				if(Modulus(safe_cast<System::Single>(idx), ll) < (ll / 2))
				{
					d += System::Single::MaxValue / 4;
				}
				else
				{
					d -= System::Single::MaxValue / 4;
				}

				d = (d > System::Single::MaxValue) ? System::Single::MaxValue: d;
				d = (d < System::Single::MinValue) ? System::Single::MinValue: d;

				data[idx] = d;
			}
			*/

			auto outSize = /*InteropServices::Marshal::SizeOf(data);//*/samplesPerSecond * 4;
			auto out = InteropServices::GCHandle::Alloc(data, InteropServices::GCHandleType::Pinned);

			auto header = Interop::Ks::KsStreamHeader();
			header.Data = out.AddrOfPinnedObject();
			header.FrameExtent = outSize;
			header.DataUsed = outSize;
			header.Size = InteropServices::Marshal::SizeOf(header);
			header.PresentationTime.Numerator = 1;
			header.PresentationTime.Denominator = 1;

			System::Console::WriteLine("[{0}] header {1}",__FUNCTION__, header);

			auto cbInBuffer = InteropServices::Marshal::SizeOf(header);
			auto pvInBuffer = InteropServices::Marshal::AllocHGlobal(cbInBuffer);

			InteropServices::Marshal::StructureToPtr(header, pvInBuffer, false);
				
			System::Console::WriteLine("==========================================");
			auto error = 
				this->_handle->IOSync(
					Interop::Ks::IOCTL_KS::WRITE_STREAM,
					System::IntPtr::Zero,
					0, 
					pvInBuffer, 
					cbInBuffer, 
					pulBytesReturned
				);

			System::Console::WriteLine("[{0}] write error {1}",__FUNCTION__, error);
			System::Console::WriteLine("[{0}] pulBytesReturned {1}",__FUNCTION__, pulBytesReturned);
			{
				auto h = safe_cast<Interop::Ks::KsStreamHeader^>(InteropServices::Marshal::PtrToStructure(pvInBuffer, Interop::Ks::KsStreamHeader::typeid));
				System::Console::WriteLine("[{0}] header {1}",__FUNCTION__, h);
			}

			System::Console::WriteLine("==========================================");

			this->State = Interop::Ks::KsState::ENUM::RUN;
			this->State;

			System::Console::WriteLine("==========================================");
			error = 
				this->_handle->IOSync(
					Interop::Ks::IOCTL_KS::WRITE_STREAM,
					System::IntPtr::Zero,
					0, 
					pvInBuffer, 
					cbInBuffer, 
					pulBytesReturned
				);

			System::Console::WriteLine("[{0}] write error {1}",__FUNCTION__, error);
			System::Console::WriteLine("[{0}] pulBytesReturned {1}",__FUNCTION__, pulBytesReturned);
			{
				auto h = safe_cast<Interop::Ks::KsStreamHeader^>(InteropServices::Marshal::PtrToStructure(pvInBuffer, Interop::Ks::KsStreamHeader::typeid));
				System::Console::WriteLine("[{0}] header {1}",__FUNCTION__, h);
			}

			System::Console::WriteLine("==========================================");

			this->State = Interop::Ks::KsState::ENUM::RUN;
			this->State;

			System::Console::WriteLine("==========================================");
			error = 
				this->_handle->IOSync(
					Interop::Ks::IOCTL_KS::WRITE_STREAM,
					System::IntPtr::Zero,
					0, 
					pvInBuffer, 
					cbInBuffer, 
					pulBytesReturned
				);

			System::Console::WriteLine("[{0}] write error {1}",__FUNCTION__, error);
			System::Console::WriteLine("[{0}] pulBytesReturned {1}",__FUNCTION__, pulBytesReturned);
			{
				auto h = safe_cast<Interop::Ks::KsStreamHeader^>(InteropServices::Marshal::PtrToStructure(pvInBuffer, Interop::Ks::KsStreamHeader::typeid));
				System::Console::WriteLine("[{0}] header {1}",__FUNCTION__, h);
			}

			System::Console::WriteLine("==========================================");

			this->State = Interop::Ks::KsState::ENUM::RUN;
			this->State;

			System::Console::ReadLine();

			InteropServices::Marshal::FreeHGlobal(pvInBuffer);
			out.Free();
		}
	}

}
}
}
