﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Ks.h
	kernel streaming
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

#include "Momiji.Interop.Guiddef.h"
#include "Momiji.Interop.Ks.h"
#include "Momiji.Core.Ks.h"
#include "Momiji.Core.Ks.PropertySet.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Ks {

	ref class FilterHandle: Irp
	{
	private:
		initonly System::String^ _devicePath;

	public:
		FilterHandle(System::String^ devicePath);
		virtual ~FilterHandle();

	protected:
		!FilterHandle();

	protected:
		virtual Interop::Kernel32::Function::File^ Open() override;
	};

	public ref class Filter
	{
	internal:
		initonly FilterHandle^	_handle;

	private:
		PropertySetTopology^	_propertySetTopology;
		PropertySetAudio^		_propertySetAudio;
		PropertySetPin^			_propertySetPin;

	public:
		Filter(System::String^ devicePath);
		virtual ~Filter();

	protected:
		!Filter();

	private:
		array<Interop::Guiddef::Guid>^	_supportProperties;
		array<Interop::Guiddef::Guid>^	_supportMethods;
		array<Interop::Guiddef::Guid>^	_supportEvents;

		void CheckSupprts();

	public:
		property PropertySetPin^ propertySetPin { PropertySetPin^ get() { return this->_propertySetPin; } };
	
	};

}
}
}
