﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Ks.cpp
	kernel streaming.
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#include "StdAfx.h"
#include "Momiji.Core.Ks.Filter.h"

namespace Momiji {
namespace Core {
namespace Ks {

	FilterHandle::FilterHandle(
		System::String^ devicePath
	):	_devicePath(devicePath), Irp()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] devicePath {1}",__FUNCTION__, this->_devicePath);
		#endif
	}

	FilterHandle::~FilterHandle()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!FilterHandle();
	}

	FilterHandle::!FilterHandle()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
	}

	Interop::Kernel32::Function::File^ FilterHandle::Open()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		auto handle =
			Interop::Kernel32::Function::CreateFile(
				this->_devicePath,
				(
						Momiji::Interop::Kernel32::ACCESS_TYPES::GENERIC_READ 
					|	Momiji::Interop::Kernel32::ACCESS_TYPES::GENERIC_WRITE
				),
				Momiji::Interop::Kernel32::SHARE_MODE::FILE_SHARE_NONE,
				System::IntPtr::Zero,
				Momiji::Interop::Kernel32::CREATION_DISPOSITION::OPEN_EXISTING,
				(
						Momiji::Interop::Kernel32::FLAG_AND_ATTRIBUTE::FILE_ATTRIBUTE_NORMAL 
					|	Momiji::Interop::Kernel32::FLAG_AND_ATTRIBUTE::FILE_FLAG_OVERLAPPED
				),
				System::IntPtr::Zero
			);
		if (handle->IsInvalid)
		{
			auto error = InteropServices::Marshal::GetHRForLastWin32Error();
			System::Console::WriteLine("[{0}] error {1:X}",__FUNCTION__, error);
			InteropServices::Marshal::ThrowExceptionForHR(error);
		}

		#ifdef _DEBUG
			System::Console::WriteLine("[{0}] Handle invalid:{1} closed:{2}",__FUNCTION__, handle->IsInvalid, handle->IsClosed);
		#endif

		return handle;
	}


	Filter::Filter(
		System::String^ devicePath
	):	_handle(gcnew FilterHandle(devicePath))
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif

		this->CheckSupprts();

		this->_propertySetTopology = gcnew PropertySetTopology(this->_handle);
		this->_propertySetAudio = gcnew PropertySetAudio(this->_handle);
		this->_propertySetPin = gcnew PropertySetPin(this->_handle);
	}

	Filter::~Filter()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		this->!Filter();
	}

	Filter::!Filter()
	{
		#ifdef _DEBUG
			System::Console::WriteLine("[{0}]",__FUNCTION__);
		#endif
		delete this->_handle;
	}

	void Filter::CheckSupprts()
	{
		{
			auto param = /*gcnew*/ Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID, Interop::Ks::PROPERTY_TYPE>();
			param.Set	= Interop::Guiddef::Guid(); //GUID_NULL
			param.Flags	= Interop::Ks::PROPERTY_TYPE::SETSUPPORT;

			this->_supportProperties =
				this->_handle->GetArray<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID, Interop::Ks::PROPERTY_TYPE>, Interop::Guiddef::Guid>(Interop::Ks::IOCTL_KS::PROPERTY, param);
		}

		{
			auto param = /*gcnew*/ Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID, Interop::Ks::METHOD_TYPE>();
			param.Set	= Interop::Guiddef::Guid(); //GUID_NULL
			param.Flags	= Interop::Ks::METHOD_TYPE::SETSUPPORT;

			this->_supportMethods =
				this->_handle->GetArray<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID, Interop::Ks::METHOD_TYPE>, Interop::Guiddef::Guid>(Interop::Ks::IOCTL_KS::METHOD, param);
		}
	
		{
			auto param = /*gcnew*/ Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID, Interop::Ks::EVENT_TYPE>();
			param.Set	= Interop::Guiddef::Guid(); //GUID_NULL
			param.Flags	= Interop::Ks::EVENT_TYPE::SETSUPPORT;

			this->_supportEvents =
				this->_handle->GetArray<Interop::Ks::KsIdentifier<Interop::Ks::PROPERTY_ID, Interop::Ks::EVENT_TYPE>, Interop::Guiddef::Guid>(Interop::Ks::IOCTL_KS::ENABLE_EVENT, param);
		}
	}

}
}
}
