﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.DeviceInfo.h
	device information
---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>

#include "Momiji.Interop.Setupapi.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace DeviceInfo {

	public ref class Devices
	{
	public:
		ref class Detail
		{
		private:
			Devices^ _devices;
			Interop::Setupapi::SpDeviceInterfaceData	_data;
			Interop::Setupapi::SpDevinfoData _info;

			System::String^ _devicePath;

			System::Boolean _noMoreItems;

		public:
			Detail(
				Devices^ devices,
				System::UInt32 index
			);
			~Detail();

		protected:
			!Detail();

		public:
			property System::Boolean	IsNoMoreItems	{ System::Boolean	get() { return this->_noMoreItems; } }
			property System::String^	DevicePath		{ System::String^	get() { return this->_devicePath; } }

		private:
			void GetDetail(System::UInt32 index);

		public:
			Interop::Setupapi::SpDeviceInterfaceData^ GetAlias(Interop::Guiddef::Guid subCategory);
			System::String^ GetDeviceRegistryProperty(Interop::Setupapi::SPDRP spdrp);
			System::String^ GetDeviceRegistryProperty(System::String^ name);
		};

		ref class DetailEnum: System::Collections::Generic::IEnumerator<Detail^>
		{
		private:
			Devices^ _devices;
			Detail^ _detail;

			System::UInt32 _index;

		public:
			DetailEnum(Devices^ devices);
			~DetailEnum() {};

		public:
			virtual System::Boolean MoveNext();
			virtual void Reset();

		public:
			property Detail^ Current			{ virtual Detail^ get() {return this->_detail;} }

		private:
			property System::Object^ _Current	{ virtual System::Object^ get() sealed = System::Collections::IEnumerator::Current::get {return this->_detail;} }

		};

		ref class DetailEnumerable: System::Collections::Generic::IEnumerable<Detail^>
		{
		private:
			Devices^ _devices;

		public:
			DetailEnumerable(Devices^ devices): _devices(devices){};

			virtual System::Collections::Generic::IEnumerator<Detail^>^ GetEnumerator() { return gcnew DetailEnum(this->_devices); };

		private:
			virtual System::Collections::IEnumerator^ _GetEnumerator() sealed = System::Collections::IEnumerable::GetEnumerator { return this->GetEnumerator(); };
		};

	private:
		Interop::Setupapi::Function::DeviceInfoSet^ _handle;
		Interop::Guiddef::Guid _category;

	public:
		Devices(
			Interop::Guiddef::Guid category,
			Interop::Setupapi::DIGCF digcf,
			System::String^ deviceName
		);

		~Devices();
	protected:
		!Devices();

	public:
		property DetailEnumerable^ Enum { DetailEnumerable^ get() { return gcnew DetailEnumerable(this); } };

	};

}
}
}
