﻿/*
[momiji music component library]
---------------------------------------------------------------------
Momiji.Core.Buffer.h

---------------------------------------------------------------------
Copyright (C) 2011 tyiki badwell {miria@users.sourceforge.jp}.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/gpl-3.0.html>.
---------------------------------------------------------------------
*/
#pragma once

#using <mscorlib.dll>
//#include "Momiji.Core.Interface.h"

using namespace System::Runtime;

namespace Momiji{
namespace Core {
namespace Buffer {

	generic<typename DATA_TYPE>
	public ref class BufferPool
	{
	public:
		delegate DATA_TYPE Allocator();

		ref class Buffer
		{
		private:
			DATA_TYPE _buffer;
			InteropServices::GCHandle _bufferHandle;
			Allocator^ _allocator;

		public:
			Buffer(Allocator^ allocator);
			virtual ~Buffer();

		protected:
			!Buffer();

		private:
			void Alloc();
			void Free();

		public:
			System::IntPtr GetBufferIntPtr();
			DATA_TYPE% GetBuffer();
		};

	private:
		System::Collections::Generic::List<Buffer^>^						_buffers;		//開放用の集合
		System::Collections::Generic::Dictionary<System::IntPtr, Buffer^>^	_idleBuffers;	//暇になっているバッファの集合
		System::Collections::Generic::Dictionary<System::IntPtr, Buffer^>^	_busyBuffers;	//再生中のバッファの集合

		System::UInt32 _defaultPoolSize;
		Allocator^ _allocator;

	public:
		BufferPool(
			System::UInt32 defaultPoolSize,
			Allocator^ allocator
		);
		~BufferPool();

	protected:
		!BufferPool();

	public:
		Buffer^ Get();
		Buffer^ GetBusy(System::IntPtr bufferPtr);
		void Release(Buffer^ buffer);
		System::Boolean IsBusy();

	private:
		Buffer^ MakeBuffer();

	};

}
}
}
