#
# Cookbook Name:: ssh_utils
# Recipe:: server
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

if node['ssh_utils']['with_ssl_cert_cookbook'] then
  if !node['ssh_utils']['ssl_cert']['ca_pubkey_name'].nil? then
    node.override['ssh_utils']['sshd_config']['extra_props']['TrustedUserCAKeys'] \
      = node['ssl_cert']["#{node['ssh_utils']['ssl_cert']['ca_pubkey_name']}_pubkey_path"]
  end

  if !node['ssh_utils']['ssl_cert']['ssh_ca_krl_name'].nil? then
    node.override['ssh_utils']['sshd_config']['extra_props']['RevokedKeys'] \
      = node['ssl_cert']["#{node['ssh_utils']['ssl_cert']['ssh_ca_krl_name']}_krl_path"]
  end
end

[
  'openssh-server',
].each {|pkg|
  resources(:package => pkg) rescue package pkg do
    action :install
  end
}
    
srv = 'sshd'
conf_mode = '0600'

case node[:platform_family]
  when 'debian'
    srv = 'ssh'
    conf_mode = '0644'
  when 'rhel'
    srv = 'sshd'
    conf_mode = '0600'
end

resources(:service => srv) rescue service srv do
  action [:enable, :start]
end

template "/etc/ssh/sshd_config" do
  source  "etc/ssh/sshd_config"
  owner 'root'
  group 'root'
  mode conf_mode
  notifies :restart, "service[#{srv}]"
end

