#
# Cookbook Name:: ssl_cert
# Attributes:: default
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# deployed CA certificates from chef-vault
default['ssl_cert']['ca_names'] = [
  #'grid_ca',
]

# deployed server keys and/or certificates from chef-vault
default['ssl_cert']['common_names'] = [
  #'ldap.grid.example.com',
]

# for chef-vault installation
default['ssl_cert']['chef_gem']['clear_sources'] = false
default['ssl_cert']['chef_gem']['source'] = nil
default['ssl_cert']['chef_gem']['options'] = nil
default['ssl_cert']['chef-vault']['version'] = '~> 2.6'

default['ssl_cert']['env_context'] = node.chef_environment
default['ssl_cert']['vault_item_suffix'] = \
  (!node['ssl_cert']['env_context'].nil? && !node['ssl_cert']['env_context'].empty?) \
  ? ".#{node['ssl_cert']['env_context']}" : ''

default['ssl_cert']['ca_cert_vault'] = 'ca_certs'
default['ssl_cert']['ca_cert_vault_item_key'] = 'public'
=begin
 CA certificate vault item name is
   each CA name + ".#{node['ssl_cert']['vault_item_suffix']}".
 valut item key is 'public'.

 * vault item management

  $ ruby -rjson -e 'puts JSON.generate({"public" => File.read("grid_ca.prod.crt")})' \
  > > ~/tmp/grid_ca.prod.crt.json
  $ knife vault create ca_certs grid_ca.prod \
  > --json ~/tmp/grid_ca.prod.crt.json
=end

default['ssl_cert']['server_key_vault'] = 'ssl_server_keys'
default['ssl_cert']['server_key_vault_item_key'] = 'private'
=begin
 server key vault item name is
   each common name + "#{node['ssl_cert']['vault_item_suffix']}".
 valut item key is 'private'.

 * vault item management

  $ ruby -rjson -e 'puts JSON.generate({"private" => File.read("node_example_com.prod.key")})' \
  > > ~/tmp/node_example_com.prod.key.json
  $ knife vault create ssl_server_keys node.example.com.prod \
  > --json ~/tmp/node_example_com.prod.key.json
=end

default['ssl_cert']['server_cert_vault'] = 'ssl_server_certs'
default['ssl_cert']['server_cert_vault_item_key'] = 'public'
=begin
 server certificate vault item name is 
   each common name + ".#{node['ssl_cert']['vault_item_suffix']}".
 valut item key is 'public'.

 * vault item management

  $ ruby -rjson -e 'puts JSON.generate({"public" => File.read("node_example_com.prod.crt")})' \
  > > ~/tmp/node_example_com.prod.crt.json
  $ knife vault create ssl_server_certs node.example.com.prod \
  > --json ~/tmp/node_example_com.prod.crt.json
=end

undotted_cns = node['ssl_cert']['common_names'].map {|item|
  item.gsub('.', '_')
}

default['ssl_cert']['certs_dir'] = node.value_for_platform_family(
  'debian' => '/etc/ssl/certs',
  'rhel'   => '/etc/pki/tls/certs'
)

default['ssl_cert']['private_dir'] = node.value_for_platform_family(
  'debian' => '/etc/ssl/private',
  'rhel'   => '/etc/pki/tls/private'
)

node['ssl_cert']['ca_names'].each {|ca|
  default['ssl_cert']["#{ca}_cert_path"] = "#{node['ssl_cert']['certs_dir']}/00#{ca}.crt"
}

undotted_cns.each {|cn|
  default['ssl_cert']["#{cn}_key_path"]  = "#{node['ssl_cert']['private_dir']}/01#{cn}.key"
  default['ssl_cert']["#{cn}_cert_path"] = "#{node['ssl_cert']['certs_dir']}/01#{cn}.crt"
}

