ssl_cert Cookbook
=================

This cookbook deploys CA certificates, SSL server keys and/or certificates from Chef Vault items.

Requirements
------------

#### packages
- nothing.

Attributes
----------

#### ssl_cert::default

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['ssl_cert']['ca_names']`|Array|deployed CA certificates from chef-vault|empty|
|`['ssl_cert']['common_names']`|Array|deployed server keys and/or certificates from chef-vault|empty|
|`['ssl_cert']['chef_gem']['clear_sources']`|Boolean|chef_gem resource's clear_sources property.|`false`|
|`['ssl_cert']['chef_gem']['source']`|String|chef_gem resource's source property.|`nil`|
|`['ssl_cert']['chef_gem']['options']`|String|chef_gem resource's options property.|`nil`|
|`['ssl_cert']['chef-vault']['version']`|String|chef-vault installation version.|`'~> 2.6'`|
|`['ssl_cert']['env_context']`|String|node's environment or nil/empty.|`node.chef_environment`|
|`['ssl_cert']['vault_item_suffix']`|String|vault item name's suffix.|`".#{node['ssl_cert']['env_context']}"`|
|`['ssl_cert']['ca_cert_vault']`|String|CA certificate stored vault name.|`'ca_certs'`|
|`['ssl_cert']['ca_cert_vault_item_key']`|String|CA certificate stored vault item key name.|`'public'`|
|`['ssl_cert']['server_key_vault']`|String|SSL server key stored vault name.|`'ssl_server_keys'`|
|`['ssl_cert']['server_key_vault_item_key']`|String|SSL server key stored vault item key name.|`'private'`|
|`['ssl_cert']['server_cert_vault']`|String|SSL server certificate stored vault name.|`'ssl_server_certs'`|
|`['ssl_cert']['server_cert_vault_item_key']`|String|SSL server certificate stored vault item key name.|`'public'`|
|`['ssl_cert']["#{ca}_cert_path"]`|String|deployed CA certificate file path.|`"#{node['ssl_cert']['certs_dir']}/00#{ca}.crt"`|
|`['ssl_cert']["#{undotted_cn}_key_path"]`|String|deployed SSL server key file path.|`"#{node['ssl_cert']['private_dir']}/01#{undotted_cn}.key"`|
|`['ssl_cert']["#{undotted_cn}_cert_path"]`|String|deployed SSL server certificate file path.|`"#{node['ssl_cert']['certs_dir']}/01#{undotted_cn}.crt"`|

Usage
-----

### recipes
- `ssl_cert::default` - deploys CA certificates, SSL server keys and/or certificates.
- `ssl_cert::ca_certs` - deploys CA certificates.
- `ssl_cert::server_key_pairs` - deploys SSL server keys and certificates.
- `ssl_cert::server_keys` - deploys SSL server keys.
- `ssl_cert::server_certs` - deploys SSL server certificates.

### Vault items creation and cookbook attribute settings (with default attributes)

#### CA certificates

- create vault items.

```text
$ ruby -rjson -e 'puts JSON.generate({"public" => File.read("grid_ca.prod.crt")})' \
> > ~/tmp/grid_ca.prod.crt.json

$ knife vault create ca_certs grid_ca.prod \
> --json ~/tmp/grid_ca.prod.crt.json
```

- add cookbook attributes.

```ruby
override_attributes(
  'ssl_cert' => {
    'ca_names' => [
      'grid_ca',
      # ...
    ],
  },
)
```

#### SSL server keys and certificates

- create vault items.

```text
$ ruby -rjson -e 'puts JSON.generate({"private" => File.read("node_example_com.prod.key")})' \
> > ~/tmp/node_example_com.prod.key.json

$ knife vault create ssl_server_keys node.example.com.prod \
> --json ~/tmp/node_example_com.prod.key.json

$ ruby -rjson -e 'puts JSON.generate({"public" => File.read("node_example_com.prod.crt")})' \
> > ~/tmp/node_example_com.prod.crt.json

$ knife vault create ssl_server_certs node.example.com.prod \
> --json ~/tmp/node_example_com.prod.crt.json
```

- add cookbook attributes

```ruby
override_attributes(
  'ssl_cert' => {
    'common_names' => [
      'node.example.com',
      # ...
    ],
  },
)
```

### References of deployed key and certificate file paths (with default attributes)

- `node['ssl_cert']["#{ca}_cert_path"]` - e.g. `node['ssl_cert']['grid_ca_cert_path']`
- `node['ssl_cert']["#{undotted_cn}_key_path"]` - e.g. `node['ssl_cert']['node_example_com_key_path']`
- `node['ssl_cert']["#{undotted_cn}_cert_path"]` - e.g. `node['ssl_cert']['node_example_com_cert_path']`

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```

