#
# Cookbook Name:: berkshelf-api-server
# Attributes:: default
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# added attributes
default[:berkshelf_api][:chef_gem][:clear_sources] = false
default[:berkshelf_api][:chef_gem][:source] = nil
default[:berkshelf_api][:chef_gem][:options] = nil
default[:berkshelf_api][:"chef-vault"][:version] = '~> 2.6'
default[:berkshelf_api][:app_host] = '0.0.0.0'
default[:berkshelf_api][:proxy][:ssl] = false
default[:berkshelf_api][:proxy][:ssl_certificate] = ''
default[:berkshelf_api][:proxy][:ssl_certificate_key] = ''
=begin
default[:berkshelf_api][:proxy][:ssl_certificate_key_vault_item] = {
  # Examples
  :vault => 'ssl_server_keys',
  :name => '<COMMON_NAME>',
  # single key or nested hash key path delimited by slash
  # Case 1.
  :env_context => false,
  :key => 'private'
  # -> item['private']
  # Case 2.
  #:env_context => true,
  #:key => 'private'
  # -> item[node.chef_environment]['private']
  # Case 3.
  #:env_context => true,
  #:key => nil,  # or '' or undefined
  # -> item[node.chef_environment]
  # Case 4.
  #:env_context => true,
  #:key => 'hash/path/to/private/key'
  # -> item[node.chef_environment]['hash']['path']['to']['private']['key']
}
=end

default[:berkshelf_api][:config][:endpoints] = [
=begin
  # Examples
  {
    :options => {
      :client_key => '/etc/berkshelf/api-server/<ORG_NAME>-berkshelf.pem',
      # added attributes
      :client_key_vault_item => {
        :vault => 'berks_api_client_keys',
        :name => '<ORG_NAME>',
        # single key or nested hash key path delimited by slash
        :env_context => false,
        :key => 'berkshelf'
        #:env_context => true,
        #:key => 'hash/path/to/private/key'
      }
    }
  },
=end
]
