#
# Cookbook Name:: apt_utils
# Recipe:: apt-cacher-ng
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

::Chef::Recipe.send(:include, Commons::PackageUtils)

if node[:platform_family] == 'debian' then
  pkg = 'apt-cacher-ng'
  user_name = pkg
  resources(:package => pkg) rescue package pkg do
    action :install
  end

  service_name = pkg
  resources(:service => service_name) rescue service service_name do
    action [:enable, :start]
    supports :status => true, :restart => true, :reload => false
  end

  directory node['apt_utils']['apt-cacher-ng']['CacheDir'] do
    owner user_name
    group user_name
    mode '2755'
    recursive true
  end
  
  directory node['apt_utils']['apt-cacher-ng']['LogDir'] do
    owner user_name
    group user_name
    mode '2755'
    recursive true
  end

  template '/etc/apt-cacher-ng/acng.conf' do
    source 'etc/apt-cacher-ng/acng.conf'
    owner 'root'
    group 'root'
    mode '0644'
    notifies :restart, "service[#{service_name}]"
  end
end

