name 'node_commons'
description 'Node common role.'

run_list(
  'role[security_update]',
  'role[apt]',
  'recipe[commons::yum-epel]',
  'recipe[commons::ntpd]',
  'recipe[ssl_cert::ca_pubkeys]',
  'recipe[ssh_utils::server]',
)

#env_run_lists()

ca_name = 'grid_ca'
ssh_ca_name = 'grid_ssh_ca'

#default_attributes()

override_attributes(
  'apt_utils' => {
    'conf' => {
      'proxy' => {
        'sequence' => '80',
        'http' => 'http://ftp.grid.example.com:3142/',
        'https' => 'DIRECT',
      },
    },
  },
  'ssh_utils' => {
    'with_ssl_cert_cookbook' => true,
    'ssl_cert' => {
      'ca_pubkey_name' => ssh_ca_name,
    },
    'sshd_config' => {
      'extra_props' => {
        # because with_ssl_cert_cookbook is set
        #'TrustedUserCAKeys' => ca_pubkeys_file,
      },
    },
  },
  'ssl_cert' => {
    'ca_cert_file_prefix' => '00',
    'ca_pubkey_file_prefix' => '00',
    'server_cert_file_prefix' => '01',
    'server_key_file_prefix' => '01',
    'ca_names' => [
      ca_name,
    ],
    'ca_pubkey_names' => [
      ssh_ca_name,
    ],
  },
)

