#
# Cookbook Name:: hadoop
# Definition:: hadoop_accounts_setup
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

define :hadoop_accounts_setup, :users => nil do
  users = params[:users]
  
  hadoop_members = []
  users.each {|key, user|
    if key != :hadoop
      hadoop_members.push(user[:name])
  
      group user[:name] do
        gid user[:uid]
        members []
        action :create
        not_if "getent group #{user[:name]}"
      end
  
      user user[:name] do
        uid user[:uid]
        gid user[:uid]
        home "/home/#{user[:name]}"
        shell '/bin/sh'
        password nil
        supports :manage_home => false
        not_if "getent passwd #{user[:name]}"
      end
    end
  }
  
  group users[:hadoop][:name] do
    gid users[:hadoop][:uid]
    members hadoop_members
    append true
    action :create
    not_if "getent group #{users[:hadoop][:name]}"
  end
  
  user users[:hadoop][:name] do
    uid users[:hadoop][:uid]
    gid users[:hadoop][:uid]
    home "/home/#{users[:hadoop][:name]}"
    shell '/bin/sh'
    password nil
    supports :manage_home => false
    not_if "getent passwd #{users[:hadoop][:name]}"
  end
end
