#
# Copyright 2013-2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'

name 'grid-ns'
description 'Grid nameservice node'

run_list(
  'role[node_commons]',
  'role[krb5-client-grid]',
  'role[ldap-client-grid]',
  #'role[ganglia-gmond]'
)

#env_run_lists()

this_subcluster = Grid::CLUSTERS[:base][:nameservices]
mcast_addr = this_subcluster[:mcast_addr]
port = '8649'
=begin
# uni-cast
udp_send_channels4ucast = []
this_subcluster[:nodes].first(2).each {|host|
  udp_send_channels4ucast.push(
    {
      'mcast_join' => '',
      'host' => "#{host}.#{Grid::DOMAIN}",
      'port' => port,
      'ttl' => ''
    }
  )
}
=end

default_attributes(
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => Grid::CLUSTERS[:base][:nameservices][:alias],
      'owner' => Grid::DOMAIN
    },
    ## static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
=begin
      ## static uni-cast
      'udp_send_channels' => udp_send_channels4ucast,
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ]
=end
    }
  }
)

