#
# Cookbook Name:: samba-grid
# Recipe:: server
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%w(
  samba
  smbclient
).each {|pkg|
  package pkg do
    action :install
  end
}

grp_conf = node['samba-grid']['group']['sambashare']
group 'sambashare' do
  action :modify
  gid grp_conf['gid'] if !grp_conf['gid'].nil? && !grp_conf['gid'].empty?
  members grp_conf['members'] if !grp_conf['members'].nil? && !grp_conf['members'].empty?
  append true
  only_if { !grp_conf['gid'].nil? && !grp_conf['gid'].empty? }
  only_if { !grp_conf['members'].nil? && !grp_conf['members'].empty? }
end

services = [
  'nmbd',
  'smbd',
]
services.push('samba-ad-dc') if node['platform'] == 'debian'
#'samba-ad-dc',  # masked on latest Ubuntu.
#'samba',        # masked on latest Debian and Ubuntu.

services.each {|srv|
  service srv do
    action [:enable]
    #action [:enable, :start]
    supports status: true, restart: true, reload: false
  end
}

# If you define same parameter repeatedly in the smb.conf,
# the last defined parameter's value is active.
template '/etc/samba/smb.conf' do
  source 'etc/samba/smb.conf'
  owner 'root'
  group 'root'
  mode '0644'
  notifies :reload, 'service[nmbd]'
  notifies :reload, 'service[smbd]'
  notifies :reload, 'service[samba-ad-dc]' if node['platform'] == 'debian'
  #notifies :reload, 'service[samba]'
end
