bind-grid Cookbook
==================

This cookbook sets up BIND server.

## Contents

- [Requirements](#requirements)
  - [Platforms](#platforms)
  - [Cookbooks](#cookbooks)
- [Attributes](#attributes)
- [Usage](#usage)
  - [Recipes](#recipes)
    - [bind-grid::default](#bind-griddefault)
    - [bind-grid::bind](#bind-gridbind)
  - [Add your customized zone files by wrapper cookbook](#add-your-customized-zone-files-by-wrapper-cookbook)
  - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### Platforms

- Debian, Ubuntu

### Cookbooks

- None.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['bind-grid']['role']`|String|`'master'` or `'slave'`|`'master'`|
|`['bind-grid']['acl']`|Hash|acl statements.|See `attribute/default.rb`|
|`['bind-grid']['acl']['internal']`|Array|Predefined `internal` acl.|`['127.0.0.1']`|
|`['bind-grid']['extra_statements']`|String|Your arbitrary statements string.|`''`|
|`['bind-grid']['options']['directory']`|String||`'/var/cache/bind'`|
|`['bind-grid']['options']['listen-on']`|String|IP v4 listen configurarions|`''`|
|`['bind-grid']['options']['listen-on']['port']`|String||`'53'`|
|`['bind-grid']['options']['listen-on']['ipaddresses']`|Array||`[]` (= `['127.0.0.1', node['ipaddress']]`)|
|`['bind-grid']['options']['listen-on-v6']`|String|IP v6 listen configurarions|`''`|
|`['bind-grid']['options']['listen-on-v6']['port']`|String||`'53'`|
|`['bind-grid']['options']['listen-on-v6']['ipaddresses']`|Array|`'any'` or `'none'`|`[]` (= `'none'`)|
|`['bind-grid']['options']['dnssec-validation']`|String||`'auto'`|
|`['bind-grid']['options']['auth-nxdomain']`|String||`'no'`|
|`['bind-grid']['options']['allow-query']`|Array||`['internal']`|
|`['bind-grid']['options']['recursion']`|String||`'yes'`|
|`['bind-grid']['options']['allow-recursion']`|Array||`['internal']`|
|`['bind-grid']['options']['allow-transfer']`|Array||`[]`|
|`['bind-grid']['options']['forwarders']`|Array||`[]`|
|`['bind-grid']['options']['extra_statements']`|String|Your arbitrary options statements string.|`''`|
|`['bind-grid']['zone']['files']`|Array|e.g. `['db.192.168.1', 'db.example.com']`|`[]`|
|`['bind-grid']['zone'] ...`|Hash|Optional: Zone file's common settings.||
|`['bind-grid']['zone']['SOA']['MNAME']`|String|e.g. `dns.example.com`|`''`|
|`['bind-grid']['zone']['SOA']['RNAME']`|String|e.g. `root.example.com`|`''`|
|`['bind-grid']['zone']['NS']`|Array|e.g. `['dns.example.com']`|`[]`|
|`['bind-grid']['zone']['masters']`|String|e.g. `['192.168.1.53']`|`''`|
|`['bind-grid']['zone']['allow-transfer']`|String|e.g. `['192.168.1.54']`|`''`|

## Usage

### Recipes

#### bind-grid::default

This recipe is the same as `bind-grid::bind`.

#### bind-grid::bind

This recipe sets up BIND server.

### Add your customized zone files by wrapper cookbook

- Create a wrapper cookbook (e.g. `bind-wrapper`).

- `metadata.rb`: add the `bind-grid` dependency.

```ruby
# ...
depends          'bind-grid'
```

- Add your zone file templates to the directory `templates/default/var/cache/bind`

- `attributes/default.rb`: add the zone file list to the `['bind-grid']['zone']['files']` attribute.

```ruby
# This attribute must not be overridden by Environments or Roles.
force_override['bind-grid']['zone']['files'] = [
  'db.192.168.1',
  'db.example.com',
]
# options
default['bind-grid']['zone'] = {
  'SOA' => {
    'MNAME' => 'dns.example.com',
    'RNAME' => 'root.example.com',
  },
  'NS' => [
    'dns.example.com',
  ],
  'masters' => [
    '192.168.1.53',
  ],
  'allow-transfer' => [
    '192.168.1.54',
  ],
}

base_cookbook = 'bind-grid'
node.from_file(run_context.resolve_attribute(base_cookbook, 'default'))
# or execute it in a recipe.
```

- `recipes/bind.rb`: override the `bind` recipe.

```ruby
base_cookbook = 'bind-grid'
this_cookbook = 'bind-wrapper'

#node.from_file(run_context.resolve_attribute(base_cookbook, 'default'))
# or execute it in the `attributes/default.rb`.
include_recipe "#{base_cookbook}::bind"

if node['bind-grid']['role'] == 'master'
  zone_dir = node['bind-grid']['options']['directory']

  # override zone files.
  node['bind-grid']['zone']['files'].each {|db_file|
    res = resources(template: "#{zone_dir}/#{db_file}")
    res.cookbook this_cookbook
  }
end
```

### Role Examples

- `roles/bind.rb`

```ruby
name 'bind'
description 'BIND server'

run_list(
  'recipe[bind-wrapper::bind]',
)

override_attributes(
  'bind-grid' => {
    'role' => 'master',  # or 'slave'
    'acl' => {
      'internal' => [
        '127.0.0.1',
        '192.168.1.0/24',
      ],
    },
    'options' => {
      'forwarders' => [
        '8.8.8.8',
        '8.8.4.4',
      ],
    },
    'zone' => {
      'SOA' => {
        'MNAME' => 'dns.example.com',
        'RNAME' => 'root.example.com',
      },
      'NS' => [
        'dns.example.com',
      ],
      'masters' => [
        '192.168.1.53',
      ],
      'allow-transfer' => [
        '192.168.1.54',
      ],
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2017, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
