/*
 * gpswitch_hal.h
 * ru utf8
 *
 *  Created on: 13 нояб. 2018 г.
 *      Author: alexrayne
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 * GPIO switching device
 * Переключатели пинов GPIO
 * Switch_Device - общий интерфейс переключателя в заданное состояние
 * SwitchLine_Device - интерфейс простейшего переключателя - с выбором одного
 *      активного пина
 */

#ifndef HAL_SWITCH_HAL_HPP_
#define HAL_SWITCH_HAL_HPP_

#include "hal_device.h"



// абстрактный интерфейс переключателя с выбором активного состояния
class Switch_Device
    //: public HAL_Device
    //, public Power_Manager
{
public:
    //return DEV_State
    virtual int select(unsigned state) =0;
    virtual int selected() const =0;
};

/* Select single pin of specified by switcher
 * */
class SwitchLine_Device
        : public HAL_Device
        , public Switch_Device
{
public:
    typedef Switch_Device inherited;
    enum {
        // no line selected
        selNONE = 0
    };
    // количество доступных состояний для select
    unsigned    sel_limit() const {return pins_amount;};

    //return DEV_State
    virtual int select(unsigned state);
    virtual int selected() const;
    // \return true if state is selected in switch
    bool is_selected(unsigned state) const;

    SwitchLine_Device(dev_name name);
    virtual int init();

protected:
    enum {
        selOFF, selON
    };
    virtual int pin_set(unsigned id, unsigned state)=0;
    virtual int pin_state(unsigned id) const =0;
    unsigned    pins_amount;
    int         selection;
};



#endif /* HAL_SWITCH_HAL_HPP_ */
