/*
 * math_util.h
 *
 *  Created on: 14/02/2019
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * --------------------------------------------------------------------------
 * здесь положу полезные мат функции
 */

#ifndef LIB_MATH_UTIL_H_
#define LIB_MATH_UTIL_H_

#include <c_compat.h>
#include <stdbool.h>
#include <stdint.h>
#include <math.h>
#include <memory.h>
#include "math_util.h"


INLINE
int ensure_range(int x, const int l, const int h){
    if (x < l)
        x = l;
    if (x > h)
        x = h;
    return x;
}

INLINE
bool in_range(const int x, const int l, const int h){
    if (x < l)
        return false;
    if (x > h)
        return false;
    return true;
}


unsigned        sqrt32( uint32_t x);
uint32_t        sqrt64( uint64_t x);

unsigned        sqrt32_ceil( uint32_t x);
uint32_t        sqrt64_ceil( uint64_t x);
unsigned        sqrt32_floor( uint32_t x);
uint32_t        sqrt64_floor( uint64_t x);




#ifdef __cplusplus

template<typename T>
INLINE
bool is_same(const T a, const T b){
    return a == b;
}

template<typename T>
INLINE
bool is_same(const T a, const T b, const T tol){
    return std::abs(a - b) < tol;
}

INLINE
bool is_same(const double& a, const double& b){
    return memcmp( &a, &b, sizeof(double) ) == 0;
}

template<typename T1, typename T2>
INLINE
T1 ensure_range(T1 x, const T2 min, const T2 max){
    if (x < min)
        x = min;
    if (x >= max)
        x = max;
    return x;
}

template<typename T1, typename T2>
INLINE
bool in_range(const T1 x, const T2 l, const T2 h){
    if (x < l)
        return false;
    if (x > h)
        return false;
    return true;
}

#endif //__cplusplus


#endif /* LIB_MATH_UTIL_H_ */
