/*
 * M95M04.h
 *
 *  Created on: 3/06/2021
 *      Author: alexrayne <alexraynepe196@gmail.com>
 * ------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
      STM M95M04-DR device is electrically erasable programmable memory (EEPROM)
          organized as 524288 x 8 bits, accessed through the SPI bus
 */

#ifndef BSP_DEV_FLASH_EEPROM_M95M04_H_
#define BSP_DEV_FLASH_EEPROM_M95M04_H_

#include "flash_spi_hal.h"

typedef SPIFlash_WritableDevice SPIFLASH_M95M04;

enum FLASHCmdId_M95{
    M95_CMD_RDID        = 0x80 | FLASH_CMD_READ,    //< Read identification page
    M95_CMD_WRID        = 0x80 | FLASH_CMD_PP,      //< Write identification page
    M95_CMD_RDLS        = M95_CMD_RDID,             //< Read identification page lock status
    M95_CMD_LID         = M95_CMD_WRID,             //< Lock identification page in react-only mode
};

enum StatusFlagID_M95 {
      M95_SR_BP0       =  (1 << 2) // block protect state
    , M95_SR_BP1       =  (1 << 3) // block protect state
    /* StatusRegisterWriteDisable bit is operated in conjunction with the write protect (W) signal. The
        status register write disable (SRWD) bit and write protect (W) signal enable the device to be put in the hardware
        protected mode (when the status register write disable (SRWD) bit is set to 1, and write protect (W) is driven low).
        In this mode, the non-volatile bits of the status register (SRWD, BP1, BP0) become read-only bits and the write
        status register (WRSR) instruction is no longer accepted for execution
    */
    , M95_SR_SWRD      =  (1 << 7)
};


#define M95M04_PAGE_SIZE 512
#define M95M04_SEC_SIZE  M95M04_PAGE_SIZE
#define M95M04_SEC_PAGES 1
#define M95M04_SECTORS   1024
#define M95M04_PAGES     (M95M04_SECTORS*M95M04_SEC_PAGES)
#define M95M04_SIZE      (M95M04_SECTORS*M95M04_SEC_SIZE)




DevResult m95m04_init(SPIFLASH_M95M04* this);
void      m95m04_connect(SPIFLASH_M95M04* this, SSP_IOPort*    _port);

// TODO: sectors protection not implemented

/*
 *  The M95M04-DR offer an additional page, named the identification page (512 bytes).
 *  The identification page can be used to store sensitive application parameters
 *  that can be (later) permanently locked in read-only mode.
 * */
DevResult m95m04_id_read(SPIFLASH_M95M04* self, unsigned addr, void* dst, unsigned len);
PTResult  m95m04_id_write(SPIFLASH_M95M04* self, unsigned addr, const void* src, unsigned len);
PTResult  m95m04_id_lock(SPIFLASH_M95M04* self);
bool      m95m04_id_locked(SPIFLASH_M95M04* self);



#endif /* BSP_DEV_FLASH_EEPROM_M95M04_H_ */
