/*
 * rl78g14_uartx.h
 *
 *  Created on: 19/11/2020
 *      Author: alexraynepe196@gmail.com
 *------------------------------------------------------------------
 *  RL78G14 uart extention for multiple serial usage
 */

#ifndef BOARDS_MCU_RL78_RL78G14_RL78G14_UARTX_H_
#define BOARDS_MCU_RL78_RL78G14_RL78G14_UARTX_H_

#include <rl78g14_uart.h>
// import:RP_SFR_CHAR/SHORT
#include <rl78g14.h>

//=========================================================================

/*! @brief declare UART for stdio serial
 *          if not declared, stdio not provided for UART
 * */
//#define RP_MCU_UART ???

/*! @brief demands use callback pFuncUartRcvHandler for stdio serial incoming
 *
 *  @note app should provide
 *      extern volatile RpUARTCallback pFuncUartRcvHandler;
 *
 * */
//#define RP_USE_DEFAULT_UART_RX_HANDLER

/*! @brief declare buffer size for stdio serial UART, if one is declared
 *          if not declared 64byte used
 * */
//#define RP_MCU_UART_BUFSIZ    (64)

/*! @brief declare macros below to establish according uart serial support
 *
 *  @note if RP_UART0 == RP_MCU_UART_0_1 - it establishes on pinouts for UART_0_1
 * */
//#define RP_UART0
//#define RP_UART1
//#define RP_UART2
//#define RP_UART3

//=========================================================================

typedef enum RP_SAUID{
    RP_SAUx0 = 0, RP_SAUx1, RP_SAUx2, RP_SAUx3,
    RP_SAUm_TOTAL,

    RP_SAU0 =0, RP_SAU1,
    RP_SAU_TOTAL,

} RP_SAChanels;

typedef volatile unsigned short RP_IOR_SHORT;
typedef volatile unsigned char  RP_IOR_CHAR;
typedef volatile __bitf_T       RP_IOR_CHARBits;

typedef union RP_IOR_SHORTL{
    RP_IOR_SHORT    r;
    RP_IOR_CHAR     l;
} RP_IOR_SHORTL;

typedef union RP_IOR_SHORTLBits{
    RP_IOR_SHORT    r;
    RP_IOR_CHAR     l;
    RP_IOR_CHARBits bit;
} RP_IOR_SHORTLBits;

/*! @brief structure definition SerialArrayUnit registers
 *
 *  this is maped from SAUmn marcoses
 * */
typedef __near struct RP_SAUnit{
    RP_IOR_SHORTL       ssr[RP_SAU_TOTAL];
    RP_IOR_SHORTL       sir[RP_SAU_TOTAL];
    RP_IOR_SHORT        smr[RP_SAU_TOTAL];
    RP_IOR_SHORT        scr[RP_SAU_TOTAL];
    RP_IOR_SHORTLBits   se;
    RP_IOR_SHORTLBits   ss;
    RP_IOR_SHORTLBits   st;
    RP_IOR_SHORT        sps;
    RP_IOR_SHORT        so;
    RP_IOR_SHORTLBits   soe;
    RP_IOR_SHORT        dummy[4];
    RP_IOR_SHORTL       sol;
    RP_IOR_SHORTL       ssc;
} RP_SAUnit;



#define  RP_SAU0 ((RP_SAUnit*)SSR00)
#define  RP_SAU1 ((RP_SAUnit*)SSR10)

#define SAU_ERRORS (SAU_PARITY_ERROR | SAU_FRAMING_ERROR | SAU_OVERRUN_ERROR)


//===================================================================================
enum rpUartResult{
    RP_UART_NOT_IMPLEMENTED = -1,
    RP_UART_UART_FAIL   = 0,
    RP_UART_OK          = 1,
};

enum {
    //! UART notification identifier for Uart_t->IrqNotify
    //      received char passes at high byte of argument
    UART_NOTIFY_ERROR       = 0x80,
    UART_NOTIFY_ERR_Msk     = 0x7f,
    //! UART_NOTIFY_ERROR pads with uart error flags
    UART_NOTIFY_ERR_FRAME   = SAU_FRAMING_ERROR,
    UART_NOTIFY_ERR_PARITY  = SAU_PARITY_ERROR ,
    UART_NOTIFY_ERR_OVER    = SAU_OVERRUN_ERROR,
};


int RpMcuUartXInit(Uart_t *obj
                        , uint8_t uartId, unsigned pbs_rate
                        , unsigned rx_mode, unsigned tx_mode
                        );
void RpMcuUartXDeInit(Uart_t *obj);

int RpMcuUartXConfig( uint8_t uartId, unsigned pbs_rate
                    , unsigned rx_mode, unsigned tx_mode );

int RpMcuUartXGetChar(Uart_t *obj);
int RpMcuUartXAvail(Uart_t *obj);

int RpMcuUartXPutChar(Uart_t *obj, unsigned char ch);
int RpMcuUartXPutData(Uart_t *obj, const void* str, unsigned len);
bool RpMcuUartXCheckTxDone(Uart_t *obj);



//----------------------------------------------------------------------------------
#if !defined(RP_USE_DEFAULT_UART_RX_HANDLER)

// API for UART of stdio is especial one.
typedef void (*RpUARTCallback)( int recvByte );
static inline
void RpMcuUartSetReceiver(RpUARTCallback app_handler){
    extern volatile RpUARTCallback pFuncUartRcvHandler;
    pFuncUartRcvHandler = app_handler;
}

#endif



#endif /* BOARDS_MCU_RL78_RL78G14_RL78G14_UARTX_H_ */
