/*
 * mcu_i2c.h
 *
 *  Created on: 5/05/2021
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * -------------------------------------------------------------------------
 */

#ifndef BSP_CPU_MCU_I2C_H_
#define BSP_CPU_MCU_I2C_H_

#include <mcu-chip.h>



#define __I2C_CAT2(a, b) a##b
#define I2C_PORT(n)  __I2C_CAT2(R_IIC, n)

#define I2C_PORT_IDXSTEP   (R_IIC1_BASE - R_IIC0_BASE)
#define I2C_PORT_NO(port)  ( ( ((uint8_t*)(port)) - R_IIC0_BASE )/I2C_PORT_IDXSTEP)



#ifdef __cplusplus
extern "C" {
#endif


typedef R_IIC0_Type             I2C_TypeDef;



#ifdef __cplusplus
}
#endif

#endif /* BSP_CPU_MCU_I2C_H_ */
