/*
 * r_sci_uartx.h
 *
 *  Created on: 19/05/2021 г.
 *      Author: alexraynepe196@gmail.com
 * ----------------------------------------------------------------------
 *   renesas UART FSP API extentions
 */

#ifndef BSP_CPU_DEV_R_SCI_UARTX_H_
#define BSP_CPU_DEV_R_SCI_UARTX_H_

#include "r_sci_uart.h"
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif


/// @brief check that R_SCI_UART_Read active
static inline
bool R_SCI_UART_rx_busy(uart_ctrl_t * p_api_ctrl){
    sci_uart_instance_ctrl_t* self = (sci_uart_instance_ctrl_t*)p_api_ctrl;
    return self->rx_dest_bytes > 0;
}

/// @brief check that R_SCI_UART_Write active
static inline
bool R_SCI_UART_tx_busy(uart_ctrl_t * const p_api_ctrl){
    sci_uart_instance_ctrl_t* self = (sci_uart_instance_ctrl_t*)p_api_ctrl;
    return self->tx_src_bytes > 0;
}



#ifdef __cplusplus
}
#endif

#endif /* BSP_CPU_DEV_R_SCI_UARTX_H_ */
