/*
 * mcu_isr.h
 *
 *  Created on: 5 дек. 2018 г.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * -------------------------------------------------------------------------
 * Порт зависимых от процессора процедур управления прерываниями
 * необходимо иметь:
 *      gie_enable()                - global interupt enable
 *      gie_disable()               - global interupt disable
 *      gie_restore(isr_save_t x)   - global interupt restore
 * В этой реализации маскировку прерываний веду через назначение BASEPRI
 * импортировано из FreeRTOS
 * Особенности:
 *      прерывания приоритета 0 - ненаскируемы
 *
 */

#ifndef HAL_MDR32F9QX_MCU_ISR_H_
#define HAL_MDR32F9QX_MCU_ISR_H_

#include <stdint.h>
#include <c_compat.h>
#include <project-conf-os.h>

#ifdef __cplusplus
extern "C" {
#endif


#include <MDR32Fx.h>

// если ОС расчитыает на то что некоторые пиоритетные прерывания ВСЕГДА работают,
//  и неотменимы она может установить это
#ifndef OSPRIO_MAX
#define OSPRIO_MAX  (1<<(8-__NVIC_PRIO_BITS))
#endif

#ifdef __cplusplus
}
#endif

#include <arm/cmsis_isr.h>

#endif /* HAL_MDR32F9QX_MCU_ISR_H_ */
