HAL - общие абстракции драйверов железа
=============================================================
библиотека АПИ устройств, и АПИ ОС.

платформы
--------------------------------------------------------------------
- `cpu/MDR32F9Qx/` - [порт для SPL 1886ВЕ94Т](MDR32F9Qx/README.md)
- `cpu/STM32*/` - порт для SPL STM32F4 - не реализован, не отлажен
- `cpu/renesas/rl78g14.lora` - порт LoRa EDK rl78g14
- `cpu/renesas/ra2l.fsp` - порт RA2L для фреймворка renesas FSP 
- `linux/`  - порт устройств под линь
- `qt/`     - порт устройств и библиотек под окружение Qt

Портирование
=============================================================
адаптация SPL железа
--------------------------------------------------------------------
библиотека HAL спроектирована с зацелом отделения функциональной части от 
аппаратной реализции.

хедеры вида `xxx_hal.hpp` - объявляют интерфейс драйвера, и имеют общий 
аппаратно-независимый код. Реализации драйвера под конкретную платформу создаются 
в папках платформы. 

сейчас реализован порт SPL Миландра для контроллеров 1886ВЕxx - [`MDR32F9Qx/`](MDR32F9Qx/README.md)

хедеры интерфейсов драйверов HAL тоже используют SPL платформы проекта, но не напрямую 
а через прокси-хедеры вида `mcu_xxx.h`. Задача их - включить нужный хедер SPL,
и адаптировать его вызовы и названия к общему виду, используемому HAL.

так же порт реализует обязательный хедер `gpio.h` - управление и настройку пинов контроллера

Для порта на другой SPL надо завести каталог платформы и, как минимум, 
написать новые `gpio.h` и `mcu_xxx.h`.

И сделать версии драйверов HAL унаследованные от интерфейсов `xxx_hal.hpp`. 
Эти реализации должны обеспечить настройку и иницализацию железа под драйвер.

адаптация к OS
--------------------------------------------------------------------
Драйвера, требующие конкурентного доступа от разных процессов, или работы с системными
часами и таймаутами используют ресурсы ОС. 
HAL использует ресурсы ОС через хедеры обертки-порты:
- `OsSync.h` - порт примитивов синхронизации ОС: 
     - *критические секци*
     - *семафор*
     - *мутекс*
     - *сигнал*
     - нитки, их управление
     - sleep

  собственно HAL использует *выделенное*, остальные ресурсы используются кодом проекта.

- `OsTime.h` - порт примитивов работы с временем: таймеры и, таймауты
- `os_isr.h` - порт управления преерываниями: вкл/выкл прерывания
- `system.h` - все остальное. Сейчас дает частоту процессора, и пустое ожидание события. 
- `halos_types.h` - хедер связывающий простые типы HAL - результаты, ошибки,
        с константами и типами ОС.

Структура
=============================================================

Общие файлы
--------------------------------------------------------------------
- `hal_types.h` - удобные типы для использования в ХАЛ.

- `halos_types.h` - хедер-образец. порты ОС, по мотивам этого хедера, адаптирую
  типы ХАЛ с типами ОС

- `hal_device.h` - перечисление интерфейсов различных устройств общего вида.
 
- `porting/` - каталог портов АПИ разных [ОС](README-OS.md).

- `hal_ringbuffer` - шаблоны кольцевой буффера. используются в буферах 
  ввода/вывода - UART, SLIP 

адаптация к компилятору
-------------------------------------------------------------------
Поддержка разных компиляторов и диалектов С/С++ осуществляется хедерами
`c_compat.h` и `compiler-port.h`

хедеры конфигурации
-------------------------------------------------------------------
- `project-conf.h` - хедер-образец. по этому образцу приложение делает этот 
  же хедер, с настройками ХАЛ под проект.

- `project-cli.h` - хедер-образец настроек [CLI](lib/cli/readme.md) под проект.

порты процессоров: `cpu/`
------------------------------------------------------------------------
- `arm/` - общий код для АРМ поддержки. дополнительный код для АРМ в `ware/contiki/arch/cpu/arm`

- `stm32.LL` - порт STM32 (семейства f4, L1) для работы на LL билиотеках

- `stm32.HAL` - порт STM32 (семейства f4, h7) для работы на HAL билиотеках. 
    ( доступно только RCC )

- `stm32.SPL` - порт STM32 (семейства f4) для работы на SPL билиотеках.
    ( доступно GPIO, DMA, UART )

- `MDR32F9Qx` - [1886ВЕ94Т под SPL ](MDR32F9Qx/README.md)

- `renesas/` - порты процессоров renesas
    - `rl78g14.lora` - импортировано и доработано из фреймворка LoRa для RL78G14
       ( доступно GPIO, буферированый UART )

    - `ra2l.fsp`     - порт для RA2L на фреймворке FSP. 
       ( доступно GPIO, буфер на драйвер UART )

библиотека: [lib/](lib/readme.md)
--------------------------------------------------------------------
- `EnumClass` - C++ обертка bitmap из enum. Позволяет кошерно в битовые операции на флагах заданных enum.
- `observe_pattern` - C++ патерн обозревателя
- `cli/` - [(Common Line Interface)](lib/cli/readme.md) библиотека реализации терминала на stdio, командной строки.

библиотека: net/
-------------------------------------------------------------------
содержит фильтры, устройства обеспечения работы с сетевыми протоколами

- `telnet_hal` - фильтр протокола телнет, на потоке stdio
- `slip-filter` - фильтр протокола SLIP прямо на буффере HAL_RingBuffer.

драйвера
-------------------------------------------------------------------
файлы `*_hal` - описание интерфейса соотвествующего устройства. 

- print_hal - драйвера строкового вывода/печати `STDOut`. Изпользуются [журналерами](lib/logapi.hpp) и [CLI](lib/cli/readme.md)
- `uart_hal` - драйвер УАРТа, с циклическим буфером на приемнике и трансмитере.
- `slip_hal` - прокси-фильтр УАРТА фреймов протокола SLIP
- `switch_hal` - переключатель набора пинов контроллера, с одним активным пином.
- `timer_hal` - базовый таймер/счетчик/ШИМ. 
- `ssp_hal` - драйвер SPI, и его прокси SPIIO реализующий `IO_Device` примитивы
- `flash_hal` - драйверы флеш-памяти, флеш на SPI, и банка флешек.
- `can_hal` - драйвер шины CAN, базовое АПИ оправки сообщения, и присоединения слота на прослушивание адреса.
- flash/    - каталог реализаций драйверов разных флешек
    - 1636RR52 - драйвер spi-флешки 1636РР52
    - x25      - универсальный драйвер на флешки протокола x25   
