/*
 * halos_types.h
 * ru cp1251
 *
 *  Created on: 13 . 2018 .
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * -----------------------------------------------------------------------
 *           
 *   contiki       
 *  PT_WAITING..PT_ENDED.       :
 *
 * :
 *    if (PT_SCHEDULE( func()) )
 *      return ptWAITING
 *
 *    DEV_State  
 */

#ifndef HAL_HALOS_TYPES_H_
#define HAL_HALOS_TYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/pt.h>



//************************************************************************
//     
enum PTResultID {
      ptWAITING = PT_WAITING
    , ptYIELDED = PT_YIELDED
    , ptEXITED  = PT_EXITED
    , ptENDED   = PT_ENDED

    //    
    , ptNOK
    , ptOK
    , ptBUSY
    , ptABORT
    , ptFAIL    = ~0
};

enum DEV_State {
    DEV_OFF = 0,
    DEV_ON = 1,
    DEV_SET = 1,
    DEV_RESET  = 0,

    DEV_NOT_IMPLEMENTED = -1,
    DEV_TIME_OUT = -2
    , DEV_FAIL   = -3

    , DEV_NOK   = ptNOK
    , DEV_OK    = ptOK
    , DEV_BUSY  = ptBUSY
    , DEV_ABORT = ptABORT
    , DEV_TOTAL
};
typedef int DevResult;

//    -  ,    unsigned 
//         .
//     PT_SCHEDULE    
//  !!!WARN:   PTResult    
//       .
//       DevResult   PT_SCHEDULE   :
//          PT_SCHEDULE( AS_PTRESULT(f) )
typedef unsigned    PTResult;
#define AS_PTRESULT(x) ((PTResult)(x))
#define AS_DEVRESULT(x) ((DevResult)(x))


#ifdef __cplusplus
}
#endif


#endif /* HAL_HALOS_TYPES_H_ */
