package F_SMTP_SEND;

# ᡼:ľSMTPá륿
#
# (C)2005 M-Fr net Michiaki Furusho

use MAIL_BASE;

# Ѿ
@ISA = ("MAIL_BASE");

# CPAN used
use Net::SMTP;

use Jcode;
use MAIL_UTIL;
use DATE;
use F_DNS;

use strict;

our $VERSION = '1.00';

# XXX AUǤޤʤΤǡ"\r\n"ǤϤʤ"\n"ˤƤ
use constant CRLF => "\n";

#private:

# XXX 顼ΥפüʤΤӽ
my %err_count_;		# 0ʤ饨顼ʤʾǥ顼ȯ
my %err_addresses_;	# @ǡ顼ɥ쥹켰
my %err_code_;		# %ǥɥ쥹򥭡˥顼code(3)
my %err_messages_;	# %ǥɥ쥹򥭡˥顼å

#public:

sub get_err_count { return $err_count_{$_[0]}; }
sub get_err_addresses { return $err_addresses_{$_[0]}; }
#
sub get_err_code
{
  my ($obj, $address) = @_;
  return ${$err_code_{$obj}}{$address};
}
sub get_err_message
{
  my ($obj, $address) = @_;
  return ${$err_messages_{$obj}}{$address};
}

#
sub set_err_count { $err_count_{$_[0]} = $_[1]; }
sub set_err_code
{
  my ($obj, $address, $code) = @_;
  ${$err_code_{$obj}}{$address} = $code;
}
sub set_err_message
{
  my ($obj, $address, $message) = @_;
  ${$err_messages_{$obj}}{$address} = $message;
}

# ɥ쥹ʤΤsetʤputˤ
sub put_err_addresses { push @{$err_addresses_{$_[0]}}, $_[1]; }

# 顼󥿤Υ󥯥
sub inc_err_count { 
  my ($obj) = @_;
  $obj->set_err_count( $obj->get_err_count + 1 );
}

# 顼Ͽ
sub set_error
{
  my ($obj, $address, $code, $message) = @_;
  #
  $obj->set_err_code($address, $code);
  $obj->set_err_message($address, $message);
  $obj->put_err_addresses($address);
  $obj->inc_err_count();
}

# XXX privateѿΤǺ
sub init
{
  my ($obj) = @_;
#print "in to F_SMTP_SEND init()\n";

  $err_count_{$obj} = 0;
  undef $err_addresses_{$obj};
  undef $err_code_{$obj};
  undef $err_messages_{$obj};

  #
  $obj->MAIL_BASE::init();
}

# 顼ʤʤundef顼з֤
sub is_err
{
  my ($obj) = @_;
  if (0 == $obj->get_err_count()) {
    return undef;
  }
  #
  return $obj->get_err_count();
}

#########################################################

# dataʬ(᡼body)κ
# XXX λBccϺα
sub make_data
{
  my ($obj) = @_;

my $md = "";
my @awk;
my $wk;

  # ᡼إåʬκ
  ############################

  # From
  $md .= "From: " . $obj->get_from() . CRLF;

  # To
  if (defined $obj->get_to()) {
    @awk = @{$obj->get_to()};
    $wk = join( "," . CRLF . "\t" , @awk);
    $md .= "To: " . $wk . CRLF;
  }

  # Cc
  if (defined $obj->get_cc()) {
    @awk = @{$obj->get_cc()};
    $wk = join( "," . CRLF . "\t" , @awk);
    $md .= "Cc: " . $wk . CRLF;
  }

  # Bcc
  if (defined $obj->get_bcc()) {
    @awk = @{$obj->get_bcc()};
    $wk = join( "," . CRLF . "\t" , @awk);
#print "Bcc : $wk \n";

    # XXX BccإåϤǺƤ
    #$md .= "Bcc: " . $wk . CRLF;
  }

  # Subject
  $md .= "Subject: " . MAIL_UTIL::b_encode($obj->get_subject()) . CRLF;

  # ¾Ƽإå
  $md .= "Message-ID: <" . MAIL_UTIL::make_message_id() . ">" . CRLF;
  $md .= "Date: " . DATE::get_mail_date() . CRLF;

  # 
  $md .= 'Content-Type: text/plain; charset=iso-2022-jp' . CRLF ;
  $md .= 'Content-Transfer-Encoding: 7bit' . CRLF ;
  $md .= 'X-Mailer: f-smtp send' . CRLF ;

  # إåνλ
  $md .= CRLF ;

  # BodyʬͿ
  $wk = $obj->get_body();
  Jcode::convert(\$wk, "jis");
  $md .= $wk;

  #
  return $md;
}

# mail_fromʬ
sub make_mail_from
{
my $ret;
  my ($obj) = @_;
  my $wk;
  unless ($wk = $obj->get_em_from()) {
    $wk = "";
  }
  if ("" ne $wk) {
    # ٥FromꤵƤΤѤ
    $ret = MAIL_UTIL::cut_address($wk);
  } else {
    # MailΥإåFrom
    $ret = MAIL_UTIL::cut_address($obj->get_from());
  }
  #
  return $ret;
}

# rcpt_toʬ
# XXX ʣβǽΤǡto¤ʤtos
sub make_rcpt_tos
{
my $ret;
my $wk;
  my ($obj) = @_;
  my @listwk;
  my @list;

  # ꤵƤХ٥To򡢤ʤХإåToCcBccѤ
  if (defined $obj->get_em_to()) {
    @listwk = @{$obj->get_em_to()};
  } else {
    if (defined $obj->get_to()) {
      @listwk = (@listwk, @{$obj->get_to()});
    }
    if (defined $obj->get_cc()) {
      @listwk = (@listwk, @{$obj->get_cc()});
    }
    if (defined $obj->get_bcc()) {
      @listwk = (@listwk, @{$obj->get_bcc()});
    }
  }
#print "list @listwk \n";

  # Ȥ
  foreach my $ad (@listwk) {
    $wk = MAIL_UTIL::cut_address($ad);
    push @list, $wk;
  }

  #
  return @list;
}

# ᥤ
sub send
{
  my ($obj) = @_;
  unless (defined $obj) {
    return undef;
  }

  # ƥޥѤʸκ
  my $mail_from = $obj->make_mail_from();
  my @rcpt_tos = $obj->make_rcpt_tos();
  my $data = $obj->make_data();
#print "MAIL FROM : $mail_from \n";
#print "RCPT TO : @rcpt_tos \n";
#print "DATA \n" . $data . "\n";

  # 
  # XXX ƥФ뤿ᡢrcpt to̡
  #####################################################
  foreach my $rcpt_to ( @rcpt_tos ) {
    # domainʬΥ
    my ($localpart, $domain) = MAIL_UTIL::split_address($rcpt_to);

    # MX쥳ɤ
    my @mxs;
    unless (@mxs = F_DNS->get_mx($domain)) {
      # 顼
      $obj->set_error($rcpt_to, "500", "can't get MX") = @_;
      next;
    }

    # ³
    my $smtpobj;
    my $flg = "false";
    while(1) {
      # ³ʤ
      if () {
        $flg = "true";
        last;
      }
    }
    # ³NGξ
    if ("false" eq $flg) {
      # 顼
      $obj->set_error($rcpt_to, $smtpobj->get_code(), $smtpobj->get_message()) = @_;
      next;
    }

    # 



    # λquit
  }

  # λ


  #
  return "OK";
}


1;

__END__
