package CGI_RESPONSE;

# CGI쥹ݥ󥹥饹
#
# (C)2002 M-Fr net Michiaki Furusho

use UTIL;
use DATE;
use strict;

our $VERSION = 1.01;

# Ϥإå켰
my %header_;

# Ϥɤ
# 0ʤ̤ϡ<>0(̾1)ʤ
my %put_flg_;

#############################################

sub new
{
  my $ob = {};
  bless $ob, shift;

  # 
  $ob->init();

  return $ob;
}

# 
sub init
{
  my ($obj) = @_;
  # ƤӽФƤʤNG
  unless (defined $obj) {
    return undef;
  }

  # ե饰򿲤
  $put_flg_{$obj} = "0";
  # ǡä
  $header_{$obj} = "";
}

# 
# XXX ɸϤ˽
# XXX Ǥ˽ϺѤߤʤundef֤
sub put
{
  my ($obj) = @_;
  # ƤӽФƤʤNG
  unless (defined $obj) {
    return undef;
  }

  if ("0" eq $put_flg_{$obj}) {
    return undef;
  }

  # 
  print $header_{$obj} . "\n";

  # ե饰ֽϺѤߡפˤơλ
  $put_flg_{$obj} = "0";
  return "OK";
}


# ʲǡΥåȷ
################################
# Coookie
# XXX RFC2109ǤϤʤָŤCookie
sub set_cookie
{
  my ($obj, $name, $value, $age, $domain , $path, $secure) = @_;

  # ƤӽФƤʤNG
  unless (defined $obj) {
    return undef;
  }

  # nameƬ'$'ΥåϤƤ
  if ($name[0] eq '$') {
    return undef;
  }
  # ʹߡͤʤνƼ
  unless (defined $value) {
    $value = "";
  }
  unless (defined $age) {
    $age = 0;
  }
  unless (defined $domain) {
    $domain = "";
  }
  unless (defined $path) {
    $path = "";
  }
  unless (defined $secure) {
    $secure = "";
  }

  # 
  my $s;
  $s = "Set-Cookie: ";
  $s .= $name . "=" . UTIL::url_encode($value);

  # ֤ͭ
  if ($age > 0) {
    $s .= "; expires=" . DATE::cookieExpires(age);
  }

  # Domain
  if ($domain ne "") {
    $s .= "; domain=" . UTIL::url_encode($domain);
  }

  # Path
  if ($path ne "") {
    $s .= "; path=" . UTIL::url_encode($path);
  }

  # Security
  if ($secure ne "") {
    $s .= "; secure";
  }

  # إåbufferϿ
  return $obj->set_header($s);
}

# ̾ν
sub set_content_html
{
  my ($obj, $jcode_type) = @_;
  # XXX ǥեȤEUC
  unless (defined $jcode_type) {
    $jcode_type = "EUC";
  }
  
  # ʬ
  my $s;
  $s = "Content-type: text/html";

  # ƥȽ
  # XXX ٤б
  if ($jcode_type =~ m/euc/i) {
    $s .= "; charset=euc-jp";
  } elsif ($jcode_type =~ m/sjis/i) {
    $s .= "; charset=shift_jis";
  } elsif ($jcode_type =~ m/shift[-_]jis/i) {
    $s .= "; charset=shift_jis";
  } elsif ($jcode_type =~ m/iso-2022-jp/i) {
    $s .= "; charset=iso-2022-jp";
  } elsif ($jcode_type =~ m/jis/i) {
    $s .= "; charset=iso-2022-jp";
  }
  # ⤷äʤʸɤϻꤷʤ

  # إåbufferϿ
  return $obj->set_header($s);
}

# ޤޤʡContent-typeͳꤹ
sub set_content
{
  my ($obj, $type) = @_;
  unless (defined $type) {
    return undef;
  }
  
  # ɲ
  return $obj->set_header("Content-type:" . $type);
}

# Content-Length
sub set_length
{
  my ($obj, $len) = @_;
  unless (defined $len) {
    return undef;
  }
  
  # ɲ
  return $obj->set_header("Content-Length:" . $len);
}


# ʥåѡ
sub set_content_plain { return $_[0]->set_content("text/plain"); }

# 
sub set_content_jpeg { return $_[0]->set_content("image/jpeg"); }
sub set_content_gif { return $_[0]->set_content("image/gif"); }
sub set_content_png { return $_[0]->set_content("image/png"); }


# Locationإå
sub set_location
{
  my ($obj, $loc) = @_;
  unless (defined $loc) {
    return undef;
  }
  
  # ɲ
  return $obj->set_header("Location:" . $loc);
}

# ̤Ѳʤ
sub set_status204
{
  return $_[0]->set_header("Status: 204 No Response");
}

# ̥ǡ򥭥å夷ʤ
sub set_nocache
{
  my ($obj) = @_;

  $obj->set_header("Expires: 0");
  $obj->set_header("Pragma: no-cache");
  $obj->set_header("Cache-Control:no-cache");

  return "OK";
}

# 礨ʤǤ롣
sub set_header
{
  my ($obj, $s) = @_;
  unless (defined $s) {
    $s = "";
  }
  if ($s eq "") {
    return undef;
  }

  # ɲ
  $header_{$obj} .= $s . "\n";

  # ե饰ΩƤ
  $put_flg_{$obj} = "1";

  # 
  return "OK";
}

1;

