#!/bin/sh

set -ex

VALGRIND=
if [ "$1" = -v ]; then
  if which valgrind 2>/dev/null; then
    VALGRIND="valgrind -q"
  fi
fi

if [ -f olha.exe ]; then
  cp olha.exe olha2
else
  cp olha olha2
fi
$VALGRIND ./olha a foo.lzh olha2
lha t foo.lzh
./olha l foo.lzh
./olha xf foo.lzh olha2
if [ -f olha.exe ]; then
  diff olha.exe olha2
else
  diff olha olha2
fi
./olha a foo.lzh olha2
rm -f olha2 foo.lzh
