// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Option.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.sys;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.ResourceEntity;
import org.hibernate.validator.Length;
/**
 * Option
 * @author nilcy
 */
@Entity
@Table(name = "option", uniqueConstraints = { @UniqueConstraint(columnNames = { "cat", "key", "val" }) })
public class Option extends ResourceEntity {
    /** S/N */
    private static final long serialVersionUID = -8687203861984259830L;
    /** Category */
    private String cat;
    /** Key */
    private String key;
    /** Val */
    private String val;
    /** Order Number */
    private Long ono = 0L;
    /**
     * Constructor
     */
    public Option() {
        // NOP
    }
    /**
     * @return Category
     */
    @Column(name = "cat", nullable = false, insertable = true, updatable = true)
    public String getCat() {
        return this.cat;
    }
    /**
     * @param aParamCat Category
     */
    public void setCat(String aParamCat) {
        this.cat = aParamCat;
    }
    /**
     * @return Key
     */
    @Column(name = "key", nullable = false, insertable = true, updatable = true)
    public String getKey() {
        return this.key;
    }
    /**
     * @param aparamKey Key
     */
    public void setKey(String aparamKey) {
        this.key = aparamKey;
    }
    /**
     * @return Val
     */
    @Column(name = "val", nullable = false, insertable = true, updatable = true)
    @Length(max = 1000)
    public String getVal() {
        return this.val;
    }
    /**
     * @param aVal Val
     */
    public void setVal(String aVal) {
        this.val = aVal;
    }
    /**
     * @return Order Number
     */
    @Column(name = "ono", nullable = false, insertable = true, updatable = true)
    public Long getOno() {
        return this.ono;
    }
    /**
     * @param aOno Order Number
     */
    public void setOno(Long aOno) {
        this.ono = aOno;
    }
}
