// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Calendar.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.sys;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.TrackEntity;
import kuzumeji.entity.def.DateCat;
import org.hibernate.validator.Length;
/**
 * Calendar
 * @author nilcy
 */
@Entity
@Table(name = "calendar", uniqueConstraints = { @UniqueConstraint(columnNames = { "date" }) })
public class Calendar extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = -7267880811152093229L;
    /** Date */
    private Date date;
    /** Date Category */
    private DateCat cat = DateCat.HOLIDAY;
    /** Date Name */
    private String name;
    /** Text */
    private String text;
    /**
     * Constructor
     */
    public Calendar() {
        // NOP
    }
    /**
     * @return Date
     */
    @Column(name = "date", nullable = false, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getDate() {
        return this.date;
    }
    /**
     * @param aDate Date
     */
    public void setDate(Date aDate) {
        this.date = aDate;
    }
    /**
     * @return Date Category
     */
    @Column(name = "cat", nullable = false, insertable = true, updatable = true)
    @Enumerated(EnumType.STRING)
    public DateCat getCat() {
        return this.cat;
    }
    /**
     * @param aCat Date Category
     */
    public void setCat(DateCat aCat) {
        this.cat = aCat;
    }
    /**
     * @return Date Name
     */
    @Column(name = "name", nullable = false, insertable = true, updatable = true)
    @Length(max = 100)
    public String getName() {
        return this.name;
    }
    /**
     * @param aName Date Name
     */
    public void setName(String aName) {
        this.name = aName;
    }
    /**
     * @return Text
     */
    @Column(name = "text", nullable = true, insertable = true, updatable = true)
    @Length(max = 1000)
    public String getText() {
        return this.text;
    }
    /**
     * @param aText Text
     */
    public void setText(String aText) {
        this.text = aText;
    }
}
