// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Role.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.idm;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.BaseEntity;
import org.jboss.seam.annotations.security.management.RoleConditional;
import org.jboss.seam.annotations.security.management.RoleGroups;
import org.jboss.seam.annotations.security.management.RoleName;
/**
 * IDM Role
 * @author nilcy
 */
@Entity
@Table(name = "role", uniqueConstraints = @UniqueConstraint(columnNames = "name"))
public class Role extends BaseEntity {
    /** S/N */
    private static final long serialVersionUID = 9177366120789064801L;
    /** Role Name */
    private String name;
    /** Conditional */
    private boolean conditional;
    /** Role Group List */
    private List<Role> groups;
    /** Constructor */
    public Role() {
        // NOP
    }
    /**
     * getter for Role Name
     * @return Role Name
     */
    @RoleName
    @Column(name = "name", nullable = false)
    public String getName() {
        return this.name;
    }
    /**
     * setter for Role Name
     * @param aName Role Name
     */
    public void setName(String aName) {
        this.name = aName;
    }
    /**
     * getter for Conditional
     * @return Conditional
     */
    @RoleConditional
    @Column(name = "conditional", nullable = false)
    public boolean isConditional() {
        return this.conditional;
    }
    /**
     * setter for Conditional
     * @param aConditional Conditional
     */
    public void setConditional(boolean aConditional) {
        this.conditional = aConditional;
    }
    /**
     * getter for Role Group List
     * @return Role Group List
     */
    @RoleGroups
    @ManyToMany
    @JoinTable(name = "role_group", joinColumns = @JoinColumn(name = "role_id"), inverseJoinColumns = @JoinColumn(name = "member_of_role"))
    public List<Role> getGroups() {
        return this.groups;
    }
    /**
     * setter for Role Group List
     * @param aGroups Role Group List
     */
    public void setGroups(List<Role> aGroups) {
        this.groups = aGroups;
    }
}
