// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: WorkerCost.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.ResourceEntity;
import kuzumeji.entity.erp.Team;
/**
 * WorkerCost
 * @author nilcy
 */
@Entity
@Table(name = "worker_cost", uniqueConstraints = { @UniqueConstraint(columnNames = { "team_id", "name" }) })
public class WorkerCost extends ResourceEntity {
    /** S/N */
    private static final long serialVersionUID = 2839815201289971174L;
    /** Team */
    private Team team;
    /** Cost Name */
    private String name;
    /** Cost Price */
    private Long cost = 0L;
    /** Unit Price */
    private Long unit = 0L;
    /**
     * Constructor
     */
    public WorkerCost() {
        // NOP
    }
    /**
     * @return Team
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "team_id", referencedColumnName = "id", nullable = true, insertable = true, updatable = true)
    public Team getTeam() {
        return this.team;
    }
    /**
     * @param aTeam Team
     */
    public void setTeam(Team aTeam) {
        this.team = aTeam;
    }
    /**
     * @return Cost Name
     */
    @Column(name = "name", nullable = false, insertable = true, updatable = true)
    public String getName() {
        return this.name;
    }
    /**
     * @param aName Cost Name
     */
    public void setName(String aName) {
        this.name = aName;
    }
    /**
     * @return Cost Price
     */
    @Column(name = "cost", nullable = false, insertable = true, updatable = true)
    public Long getCost() {
        return this.cost;
    }
    /**
     * @param aCost Cost Price
     */
    public void setCost(Long aCost) {
        this.cost = aCost;
    }
    /**
     * @return Unit Price
     */
    @Column(name = "unit", nullable = false, insertable = true, updatable = true)
    public Long getUnit() {
        return this.unit;
    }
    /**
     * @param aUnit Unit Price
     */
    public void setUnit(Long aUnit) {
        this.unit = aUnit;
    }
}
