// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: ActualWork.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.mng;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
/**
 * ActualPeriod Work Hours
 * @author nilcy
 */
import javax.persistence.UniqueConstraint;
import kuzumeji.entity.BaseEntity;
/**
 * ActualWork
 * @author nilcy
 */
@Entity
@Table(name = "actual_work_detail", uniqueConstraints = { @UniqueConstraint(columnNames = { "actual_period_id", "date" }) })
public class ActualWork extends BaseEntity {
    /** S/N */
    private static final long serialVersionUID = 3654375276166667381L;
    /** Actual Period */
    private ActualPeriod actualPeriod;
    /** Work Date */
    private Date date;
    /** Work Hours */
    private Double hours;
    /**
     * Constructor
     */
    public ActualWork() {
        // NOP
    }
    /**
     * @return Actual Period
     */
    @ManyToOne(cascade = CascadeType.REFRESH, fetch = FetchType.LAZY)
    @JoinColumn(name = "actual_period_id", referencedColumnName = "id", nullable = false, insertable = true, updatable = true)
    public ActualPeriod getActualPeriod() {
        return this.actualPeriod;
    }
    /**
     * @param aActual Actual Period
     */
    public void setActualPeriod(ActualPeriod aActual) {
        this.actualPeriod = aActual;
    }
    /**
     * @return Work Date
     */
    @Column(name = "date", nullable = false, insertable = true, updatable = true)
    @Basic
    @Temporal(TemporalType.DATE)
    public Date getWorkDate() {
        return this.date;
    }
    /**
     * @param aWorkDate Work Date
     */
    public void setWorkDate(Date aWorkDate) {
        this.date = aWorkDate;
    }
    /**
     * @return Work Hours
     */
    @Column(name = "hours", nullable = false, insertable = true, updatable = true, precision = 8, scale = 0)
    public Double getHours() {
        return this.hours;
    }
    /**
     * @param aHours Work Hours
     */
    public void setHours(Double aHours) {
        this.hours = aHours;
    }
}
