// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $$Id: Person.java 1669 2009-11-08 11:43:31Z kuzumeji $$
// ============================================================
package kuzumeji.entity.erp.fin.pl;
import kuzumeji.entity.TrackEntity;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
/**
 * Profit and Loss Statement
 * @author nilcy
 */
@Entity
@Table(name = "profit_loss")
public class ProfitLoss extends TrackEntity {
    /** S/N */
    private static final long serialVersionUID = -5906481980886497613L;
    /** A. Sales */
    private Long sales = 0L;
    /** B. Cost of goods sold */
    private Long cogs = 0L;
    /** C. Gross margin (=A-B) */
    // private Long grossMargin;
    /** D. Selling expense, general and administrative expense */
    private Long sellingExpense = 0L;
    /** E. Operating income profit (=C-D) or loss */
    // private Long operatingIncome;
    /** F. Other revenue */
    private Long otherRevenues = 0L;
    /** G. Other expenses */
    private Long otherExpenses = 0L;
    /** H. Current earnings (=E+F-G) or loss */
    // private Long currentEarnings;
    /** I. Extraordinary earnings */
    private Long extraordinaryEarnings = 0L;
    /** J. Extraordinary loss */
    private Long extraordinaryLoss = 0L;
    /** K. Pretax financial (book) income (=H+I-J) or loss */
    // private Long pretaxIncome;
    /** L. Income tax (IT) */
    private Long incomeTax = 0L;
    /** M. Income taxes adjustment */
    private Long incomeTaxesAdjustment = 0L;
    /** N. Net income (=K-L+M) */
    // private Long netIncome;
    /**
     * getter for A. Sales
     * @return A. Sales
     */
    @Column(name = "sales", nullable = false, insertable = true, updatable = true)
    public Long getSales() {
        return this.sales;
    }
    /**
     * setter for A. Sales
     * @param aSales A. Sales
     */
    public void setSales(Long aSales) {
        this.sales = aSales;
    }
    /**
     * getter for B. Cost of goods sold
     * @return B. Cost of goods sold
     */
    @Column(name = "cogs", nullable = false, insertable = true, updatable = true)
    public Long getCogs() {
        return this.cogs;
    }
    /**
     * setter for B. Cost of goods sold
     * @param aCogs B. Cost of goods sold
     */
    public void setCogs(Long aCogs) {
        this.cogs = aCogs;
    }
    /**
     * getter for C. Gross margin (=A-B)
     * @return C. Gross margin (=A-B)
     */
    @Transient
    public Long getGrossMargin() {
        return getSales() - getCogs();
    }
    /**
     * getter for D. Selling expense, general and administrative expense
     * @return D. Selling expense, general and administrative expense
     */
    @Column(name = "selling_expense", nullable = false, insertable = true, updatable = true)
    public Long getSellingExpense() {
        return this.sellingExpense;
    }
    /**
     * setter for D. Selling expense, general and administrative expense
     * @param aSellingExpense D. Selling expense, general and administrative expense
     */
    public void setSellingExpense(Long aSellingExpense) {
        this.sellingExpense = aSellingExpense;
    }
    /**
     * getter for E. Operating income profit (=C-D) or loss
     * @return E. Operating income profit (=C-D) or loss
     */
    @Transient
    public Long getOperatingIncome() {
        return getGrossMargin() - getSellingExpense();
    }
    /**
     * getter for F. Other revenue
     * @return F. Other revenue
     */
    @Column(name = "other_revenues", nullable = false, insertable = true, updatable = true)
    public Long getOtherRevenues() {
        return this.otherRevenues;
    }
    /**
     * setter for F. Other revenue
     * @param aOtherRevenues F. Other revenue
     */
    public void setOtherRevenues(Long aOtherRevenues) {
        this.otherRevenues = aOtherRevenues;
    }
    /**
     * getter for G. Other expenses
     * @return G. Other expenses
     */
    @Column(name = "other_expenses", nullable = false, insertable = true, updatable = true)
    public Long getOtherExpenses() {
        return this.otherExpenses;
    }
    /**
     * setter for G. Other expenses
     * @param aOtherExpenses G. Other expenses
     */
    public void setOtherExpenses(Long aOtherExpenses) {
        this.otherExpenses = aOtherExpenses;
    }
    /**
     * getter for H. Current earnings (=E+F-G) or loss
     * @return H. Current earnings (=E+F-G) or loss
     */
    @Transient
    public Long getCurrentEarnings() {
        return getOperatingIncome() + getOtherRevenues() - getOtherExpenses();
    }
    /**
     * getter for I. Extraordinary earnings
     * @return I. Extraordinary earnings
     */
    @Column(name = "extraordinary_earnings", nullable = false, insertable = true, updatable = true)
    public Long getExtraordinaryEarnings() {
        return this.extraordinaryEarnings;
    }
    /**
     * setter for I. Extraordinary earnings
     * @param aExtraordinaryEarnings I. Extraordinary earnings
     */
    public void setExtraordinaryEarnings(Long aExtraordinaryEarnings) {
        this.extraordinaryEarnings = aExtraordinaryEarnings;
    }
    /**
     * getter for J. Extraordinary loss
     * @return J. Extraordinary loss
     */
    @Column(name = "extraordinary_loss", nullable = false, insertable = true, updatable = true)
    public Long getExtraordinaryLoss() {
        return this.extraordinaryLoss;
    }
    /**
     * setter for J. Extraordinary loss
     * @param aExtraordinaryLoss J. Extraordinary loss
     */
    public void setExtraordinaryLoss(Long aExtraordinaryLoss) {
        this.extraordinaryLoss = aExtraordinaryLoss;
    }
    /**
     * getter for K. Pretax financial (book) income (=H+I-J) or loss
     * @return K. Pretax financial (book) income (=H+I-J) or loss
     */
    @Transient
    public Long getPretaxIncome() {
        return getCurrentEarnings() + getExtraordinaryEarnings() - getExtraordinaryLoss();
    }
    /**
     * getter for L. Income tax (IT)
     * @return L. Income tax (IT)
     */
    @Column(name = "income_tax", nullable = false, insertable = true, updatable = true)
    public Long getIncomeTax() {
        return this.incomeTax;
    }
    /**
     * setter for L. Income tax (IT)
     * @param aIncomeTax L. Income tax (IT)
     */
    public void setIncomeTax(Long aIncomeTax) {
        this.incomeTax = aIncomeTax;
    }
    /**
     * getter for M. Income taxes adjustment
     * @return M. Income taxes adjustment
     */
    @Column(name = "income_taxes_adjustment", nullable = false, insertable = true, updatable = true)
    public Long getIncomeTaxesAdjustment() {
        return this.incomeTaxesAdjustment;
    }
    /**
     * setter for M. Income taxes adjustment
     * @param aIncomeTaxesAdjustment M. Income taxes adjustment
     */
    public void setIncomeTaxesAdjustment(Long aIncomeTaxesAdjustment) {
        this.incomeTaxesAdjustment = aIncomeTaxesAdjustment;
    }
    /**
     * getter for N. Net income (=K-L+M)
     * @return N. Net income (=K-L+M)
     */
    @Transient
    public Long getNetIncome() {
        return getPretaxIncome() - getIncomeTax() + getIncomeTaxesAdjustment();
    }
}
