// //////////////////////////////////////////////////////////
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 2, June 1991 ____
// _________ http://www.gnu.org/licenses/gpl.html __________
// File: $Id: Contact.java 1669 2009-11-08 11:43:31Z kuzumeji $
// //////////////////////////////////////////////////////////
package kuzumeji.entity.erp.fin.cs;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
/**
 * Cash flow for Operating Activities
 * @author nilcy
 */
@Embeddable
public class CS4Operating implements Serializable, Cloneable {
    /** S/N */
    private static final long serialVersionUID = -6840956276052459540L;
    /** Net income */
    private Long netIncome = 0L;
    /** Depreciation expense */
    private Long depreciationExpense = 0L;
    /** Sales credit differences */
    private Long salesCreditDiff = 0L;
    /** Inventory differences */
    private Long inventoryDiff = 0L;
    /** Purchase credit differences */
    private Long purchaseCreditDiff = 0L;
    /** Cash paid for income tax */
    private Long cashPaidIncomeTax = 0L;
    /**
     * getter for Net income
     * @return Net income
     */
    @Column(name = "netIncome", nullable = false, insertable = true, updatable = true)
    public Long getNetIncome() {
        return this.netIncome;
    }
    /**
     * setter for Net income
     * @param aNetIncome Net income
     */
    public void setNetIncome(Long aNetIncome) {
        this.netIncome = aNetIncome;
    }
    /**
     * getter for Depreciation expense
     * @return Depreciation expense
     */
    @Column(name = "depreciation_expense", nullable = false, insertable = true, updatable = true)
    public Long getDepreciationExpense() {
        return this.depreciationExpense;
    }
    /**
     * setter for Depreciation expense
     * @param aDepreciationExpense Depreciation expense
     */
    public void setDepreciationExpense(Long aDepreciationExpense) {
        this.depreciationExpense = aDepreciationExpense;
    }
    /**
     * getter for Sales credit differences
     * @return Sales credit differences
     */
    @Column(name = "sales_credit_diff", nullable = false, insertable = true, updatable = true)
    public Long getSalesCreditDiff() {
        return this.salesCreditDiff;
    }
    /**
     * setter for Sales credit differences
     * @param aSalesCreditDiff Sales credit differences
     */
    public void setSalesCreditDiff(Long aSalesCreditDiff) {
        this.salesCreditDiff = aSalesCreditDiff;
    }
    /**
     * getter for Inventory differences
     * @return Inventory differences
     */
    @Column(name = "inventory_diff", nullable = false, insertable = true, updatable = true)
    public Long getInventoryDiff() {
        return this.inventoryDiff;
    }
    /**
     * setter for Inventory differences
     * @param aInventoryDiff Inventory differences
     */
    public void setInventoryDiff(Long aInventoryDiff) {
        this.inventoryDiff = aInventoryDiff;
    }
    /**
     * getter for Purchase credit differences
     * @return Purchase credit differences
     */
    @Column(name = "purchase_credit_diff", nullable = false, insertable = true, updatable = true)
    public Long getPurchaseCreditDiff() {
        return this.purchaseCreditDiff;
    }
    /**
     * setter for Purchase credit differences
     * @param aPurchaseCreditDiff Purchase credit differences
     */
    public void setPurchaseCreditDiff(Long aPurchaseCreditDiff) {
        this.purchaseCreditDiff = aPurchaseCreditDiff;
    }
    /**
     * calc subtotal
     * @return subtotal
     */
    @Transient
    public long subtotal() {
        return getNetIncome() + getDepreciationExpense() + getSalesCreditDiff() + getInventoryDiff()
                + getPurchaseCreditDiff();
    }
    /**
     * getter for Cash paid for income tax
     * @return Cash paid for income tax
     */
    @Column(name = "cash_paid_income_tax", nullable = false, insertable = true, updatable = true)
    public Long getCashPaidIncomeTax() {
        return this.cashPaidIncomeTax;
    }
    /**
     * setter for Cash paid for income tax
     * @param aCashPaidIncomeTax Cash paid for income tax
     */
    public void setCashPaidIncomeTax(Long aCashPaidIncomeTax) {
        this.cashPaidIncomeTax = aCashPaidIncomeTax;
    }
    /**
     * calc total
     * @return total
     */
    @Transient
    public long total() {
        return subtotal() + getCashPaidIncomeTax();
    }
}
